package cn.com.duiba.developer.center.api.remoteservice.saas;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.saas.SaasAgentDto;
import cn.com.duiba.developer.center.api.domain.paramquery.SaasAgentParams;

import java.util.List;

/**
 * Created by zyj on 2018/5/18.
 */
@AdvancedFeignClient
public interface RemoteSaasAgentService {
    Long insert(SaasAgentDto saasAgentDto);

    Integer selectCountByParams(SaasAgentParams saasAgentParam);

    List<SaasAgentDto> selectListByParams(SaasAgentParams saasAgentParam);

    /**
     * id查询
     * @param id
     * @return
     */
    SaasAgentDto findById(Long id);

    /**
     * 批量查询代理商
     * @param agentIds
     * @return
     */
    List<SaasAgentDto> findByAgentIds(List<Long> agentIds);

    Integer update(SaasAgentDto saasAgentDto);

    /**
     * 根据代理商名称模糊搜索代理商信息
     * @param agentName 代理商名称
     * @return 代理商信息
     */
    List<SaasAgentDto> findAgentByNameLike(String agentName);

    /**
     * 根据代理商邮箱查询代理商
     * @param email 邮箱
     * @return 代理商信息
     */
    SaasAgentDto findAgentByEmail(String email);
}
