package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * @author fengyibo
 * @date 2018/7/9 11:35
 */
public enum GrantStatusEnum {
    UNEXPIRED(1,"服务期"),
    BE_EXPIRED(2,"已过期"),
    EXPIRING(3,"即将过期");
    private Integer value;

    private String desc;

    GrantStatusEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private static final Map<Integer, GrantStatusEnum> enumMap = new HashMap<>();
    
    static{
        for(GrantStatusEnum grantStatusEnum : values()){
            enumMap.put(grantStatusEnum.getValue(), grantStatusEnum);
        }
    }

    public static GrantStatusEnum getByCode(Integer code){
        GrantStatusEnum grantStatusEnum = enumMap.get(code);
        if(grantStatusEnum == null){
            throw new DeveloperCenterException("不支持的功能类型");
        }
        return grantStatusEnum;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
