package cn.com.duiba.developer.center.api.remoteservice.message;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.message.MessageDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @Description 央视频短信发送服务
 * @Author huliangsheng
 * @Date 2025/9/9 17:37
 */
@AdvancedFeignClient
public interface RemoteCnMessageSendService {

    /**
     * 短信发送
     *
     * @param mobile     接收短信的手机号
     * @param templateId 短信模版ID
     * @param signName   短信签名，发送国内短信该参数必填，且需填写签名内容而非签名ID。发送国际/港澳台短信该参数非必填。
     */
    MessageDto sendMessage(String mobile, String templateId, String signName);

}
