package cn.com.duiba.developer.center.api.remoteservice.visualeditor;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * HBase数据迁移远程服务接口
 * 
 * @author system
 * @date 2025/01/XX
 */
@AdvancedFeignClient
public interface RemoteVisualEditorHbaseMigrationService {

    /**
     * 根据应用ID将HBase中的组件dataJson迁移到MySQL
     * 
     * @param appId 应用ID
     * @return 迁移结果信息
     */
    HbaseMigrationResult migrateByAppId(Long appId);

    /**
     * 迁移结果
     */
    class HbaseMigrationResult {
        private Long appId;
        private int totalCount;      // 总记录数
        private int successCount;    // 成功迁移数
        private int failCount;       // 失败数
        private int notFoundCount;   // HBase中未找到数据数
        private String message;      // 结果消息

        public HbaseMigrationResult() {
        }

        public HbaseMigrationResult(Long appId) {
            this.appId = appId;
        }

        public Long getAppId() {
            return appId;
        }

        public void setAppId(Long appId) {
            this.appId = appId;
        }

        public int getTotalCount() {
            return totalCount;
        }

        public void setTotalCount(int totalCount) {
            this.totalCount = totalCount;
        }

        public int getSuccessCount() {
            return successCount;
        }

        public void setSuccessCount(int successCount) {
            this.successCount = successCount;
        }

        public int getFailCount() {
            return failCount;
        }

        public void setFailCount(int failCount) {
            this.failCount = failCount;
        }

        public int getNotFoundCount() {
            return notFoundCount;
        }

        public void setNotFoundCount(int notFoundCount) {
            this.notFoundCount = notFoundCount;
        }

        public String getMessage() {
            return message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}
