package cn.com.duiba.developer.center.api.utils;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.URI;
import java.net.URLDecoder;

public class UrlUtils {
    private static final Logger logger = LoggerFactory.getLogger(UrlUtils.class);

    public static String getRedirectHost(String url) {
        if(StringUtils.isBlank(url)){
            return null;
        }

        try{
            URI uri = new URI(url);
            if(StringUtils.isBlank(uri.getHost())){
                String urlStr = URLDecoder.decode(url, "UTF-8");
                uri = new URI(urlStr);
            }
            return uri.getHost();
        }catch(Exception e){
            logger.error("URLDecoder.decode error:{}", url, e);
        }
        return null;
    }

    public static void main(String[] args) throws Exception{
        String url = "http://www.baidu.com/xxx/yyy?zzz=1";
        String host = UrlUtils.getRedirectHost(url);

        int index = url.indexOf(host);
        int start = index + host.length();
        String subString = url.substring(start, url.length());
        System.out.println(host + "***" + index);
        System.out.println(subString);
    }
}
