package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.RecommendBlacklistDto;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
@AdvancedFeignClient
public interface RemoteDuibaRecommendQueueBlacklistService {

	/**
	 * 保存推荐位黑名单
	 * @param list 页面批量传过来的黑名单的数据
	 */
	public DubboResult<Integer> saveRecommendQueueBlacklist(List<RecommendBlacklistDto> list);
	
	/**
	 * 删除推荐位黑名单
	 * @param appId 应用ID
	 */
	public DubboResult<Integer> deleteRecommendQueueBlacklist(Long appId);
	
	/**
	 * 编辑黑名单
	 * @param appId 应用ID
	 * @param duibaActivity 兑吧活动
	 * @param ownActivity 自有活动
	 * @param goods 商品(兑换项)
	 */
	public DubboResult<Integer> updateRecommendQueueBlacklist(Long appId, boolean duibaActivity, boolean ownActivity, boolean goods);
	
	/**
	 * 根据传入的参数进行查询
	 * @param appId 应用ID 精确查询
	 */
	public DubboResult<RecommendBlacklistDto> findRecommendQueueBlacklistByAppId(Long appId);
	
	/**
	 * 分页查询黑名单
	 * @param offset 偏移量
	 * @param max 查询条数
	 */
	public DubboResult<PaginationVO<RecommendBlacklistDto>> findAllRecommendQueueBlacklist(PageQueryEntity params);
	
	/**
	 * 查询黑名单总记录数
	 */
	public Long findRecommendQueueBlacklistTotalRecord();
	
}
