package cn.com.duiba.developer.center.api.remoteservice.saas;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.saas.SaasItemDto;
import cn.com.duiba.developer.center.api.domain.dto.saas.SaasVersionProfitDto;
import cn.com.duiba.developer.center.api.domain.param.SaasOrder2ItemParam;
import cn.com.duiba.developer.center.api.domain.enums.saas.SaasFuncTypeEnum;
import cn.com.duiba.developer.center.api.domain.param.SaasProductManagerParam;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
*
* @Description:
* @Author:       yangcong
* @CreateDate:   2018/8/3 20:29
*/
@AdvancedFeignClient
public interface RemoteSaasItemSevice {

    /**
     * 查询商品化产品列表
     * @param param
     * @return
     */
    DubboResult<List<SaasItemDto>> selectAllList(SaasProductManagerParam param);

    /**
     * 查询商品化产品总数量
     * @param param
     * @return
     */
    DubboResult<Integer> selectCountByParam(SaasProductManagerParam param);


    /**
     * 保存商品化产品
     * @param saasItemDto 商品化产品DTO
     * @return
     */
    Long insert(SaasItemDto saasItemDto);

    /**
     * 更新商品化产品
     * @param saasItemDto 商品化产品DTO
     * @return
     */
    Integer update(SaasItemDto saasItemDto);
    /**
     * 查询所有的版本权益
     * @return
     */
    List<SaasVersionProfitDto> selectVersionProfitList();

    /**
     * 配置版本权益
     * @param profitDtoList
     * @return
     */
    Integer configVersionPro(List<SaasVersionProfitDto> profitDtoList);

    /**
     * 是否存在Saas版本产品
     * @return
     */
    Boolean isSaasVersionItem();


    /**
     * 配置商品权益
     * @param ids
     * @param versionProfitType
     * @return
     */
    Integer updateItemProfit(List<Long> ids,Integer versionProfitType);

    /**
     * 通过订单查询到对应的商品信息
     * @return
     */
    List<SaasItemDto> selectByFunc(List<SaasOrder2ItemParam> saasOrder2ItemParam);

    /**查询单个saas商品
     * @param id
     * @return
     */
    SaasItemDto findSaasItemById(Long id);

    /**查询所有的Saas商品
     * @param id
     * @return
     */
    List<SaasItemDto> findAllSaasItem();

    /**
     * 通过主键查询
     * @param funcType
     * @param funcSubType
     * @param funcRelId
     * @return
     */
    SaasItemDto findByUK(SaasFuncTypeEnum funcType, Integer funcSubType, Long funcRelId);

    /**
     * 根据商品的名称查询itemIds
     * @param itemName
     * @return
     */
    List<Long> selectItemIdsByName(String itemName);

    /**根据ids查询Saas商品
     * @param
     * @return
     */
    List<SaasItemDto> findItemByIds(List<Long> ids);



    boolean updateSaleById(Long Id, Integer modify);

}
