package cn.com.duiba.developer.center.api.domain.enums;

import java.util.Objects;

/**
 * @author JunAngLiu
 * @Title: DeletedEnum
 * @Description: 是否删除
 * @date 2018/12/2516:35
 */
public enum DeletedEnum {
    NO(0,"未删除"),
    YES(1,"删除");

    private Integer value;
    private String desc;

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    DeletedEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }



    public static DeletedEnum getByValue(Integer value){
        if(value == null){
            return null;
        }
        for(DeletedEnum deletedEnum:DeletedEnum.values()){
            if(Objects.equals(deletedEnum.getValue(),value) ){
                return deletedEnum;
            }
        }
        return null;
    }
}
