package cn.com.duiba.developer.center.api.remoteservice.buoy;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.PageDto;
import cn.com.duiba.developer.center.api.domain.dto.buoyVisual.BuoyVisualConfDto;
import cn.com.duiba.service.exception.BusinessException;

import java.util.List;

/**
 * @author JunAngLiu
 * @Title: RemoteBuoyVisualConfService
 * @Description: 组件化 浮标
 * @date 2018/12/2516:03
 */
@AdvancedFeignClient
public interface RemoteBuoyVisualConfService {

    /**
     * 新增浮标
     * @param record
     * @return
     */
    long insert(BuoyVisualConfDto record);

    /**
     * 根据主键查询
     * @param id
     * @return
     */
    BuoyVisualConfDto selectByPrimaryKey(Long id);

    /**
     * 根据 appId  和  状态 查询
     * @param appId
     * @return
     */
    List<BuoyVisualConfDto> selectOpenConfByAppId(long appId);

    /**
     * 根据主键 动态修改
     * @param record
     * @return
     */
    Boolean updateByPrimaryKeySelective(BuoyVisualConfDto record) throws BusinessException;

    /**
     * 分页查询
     * @param pageNo
     * @param pageSize
     * @return
     */
    PageDto<BuoyVisualConfDto> selectPage(int pageNo, int pageSize);

}
