package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by 92072 on 2018/5/30.
 */
public enum AdminTypeEnum {
    /**
     * master 主账户
     */
    MASTER("master", "主账户"),
    SLAVE("slave", "子账户");
    private String value;
    private String desc;

    private static final Map<String, AdminTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(AdminTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getValue(), tmp);
        }
    }

    public static AdminTypeEnum getByValue(String value){
        AdminTypeEnum result = ENUM_MAP.get(value);
        if(result == null){
            throw new DeveloperCenterException("不支持的进度类型");
        }
        return result;
    }
    AdminTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
