/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.utils;

import cn.com.duiba.developer.center.api.domain.dto.AppNewExtraDto;
import cn.com.duiba.developer.center.api.domain.dto.saas.SaasGrantDto;
import cn.com.duiba.developer.center.api.domain.dto.saas.SaasItemDto;
import cn.com.duiba.developer.center.api.domain.enums.AccessAccountStatusEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.SaasFuncTypeEnum;
import cn.com.duiba.developer.center.api.domain.paramquery.SaasGrantQueryParam;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppNewExtraService;
import cn.com.duiba.developer.center.api.remoteservice.saas.RemoteSaasDevFreeService;
import cn.com.duiba.developer.center.api.remoteservice.saas.RemoteSaasGrantService;
import cn.com.duiba.developer.center.api.remoteservice.saas.RemoteSaasItemSevice;
import cn.com.duiba.developer.center.api.utils.RedisKeyFactory;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaasGrantUtil {
    private static Logger logger = LoggerFactory.getLogger(SaasGrantUtil.class);
    private static RemoteSaasGrantService remoteSaasGrantService;
    private static RemoteSaasDevFreeService remoteSaasDevFreeService;
    private static AdvancedCacheClient advancedCacheClient;
    private static RemoteSaasItemSevice remoteSaasItemSevice;
    private static RemoteAppNewExtraService remoteAppNewExtraService;
    public static final Long PROBATION_LIMIT_IN_DAY;
    private static final Cache<Long, Boolean> canFreeUseCache;
    private static final Cache<Long, Boolean> accessAccountCache;
    private static final Cache<String, Optional<SaasGrantDto>> grantCache;
    private static final Cache<String, Boolean> saasItemCache;

    public static boolean canFreeUse(Long developerId, Long appId, boolean degradedRunning) {
        try {
            if (appId == null) {
                return false;
            }
            return (Boolean)canFreeUseCache.get((Object)appId, () -> Boolean.TRUE.equals(remoteSaasDevFreeService.canFreeUse(developerId, appId)));
        }
        catch (Exception e) {
            logger.warn("\u514d\u8d39\u540d\u5355\u67e5\u8be2\u53d1\u751f\u5f02\u5e38, \u662f\u5426\u964d\u7ea7:{},developerId={}, appId={}, errmsg={}", new Object[]{degradedRunning, developerId, appId, e.getMessage()});
            return degradedRunning;
        }
    }

    public static boolean canAccessAccount(Long appId, boolean degradedRunning) {
        try {
            if (appId == null) {
                return false;
            }
            return (Boolean)accessAccountCache.get((Object)appId, () -> {
                AppNewExtraDto appNewExtraDto = remoteAppNewExtraService.findByAppIdNew(appId);
                return appNewExtraDto != null && StringUtils.equals((CharSequence)appNewExtraDto.getAccountSystem(), (CharSequence)AccessAccountStatusEnum.STATUS_OPEN.getCode());
            });
        }
        catch (Exception e) {
            logger.warn("\u63a5\u5165\u8d26\u53f7\u4f53\u7cfb\u540d\u5355\u67e5\u8be2\u53d1\u751f\u5f02\u5e38, \u662f\u5426\u964d\u7ea7:{}, appId={},errmsg={}", new Object[]{degradedRunning, appId, e.getMessage()});
            return degradedRunning;
        }
    }

    private static String generateKey(Long appId, SaasFuncTypeEnum funcType, Integer funcSubType, Long funcRelId) {
        StringBuilder builder = new StringBuilder();
        builder.append(appId).append("_").append((Object)funcType).append("_").append(funcSubType == null ? SaasGrantDto.DEFAULT_FUNC_SUB_TYPE : funcSubType).append("_").append(funcRelId == null ? SaasGrantDto.DEFAULT_FUNC_REL_ID : funcRelId);
        return builder.toString();
    }

    public static SaasGrantDto getGrant(Long appId, SaasFuncTypeEnum funcType, Integer funcSubType, Long funcRelId) throws ExecutionException {
        if (appId == null || funcType == null) {
            return null;
        }
        String key = SaasGrantUtil.generateKey(appId, funcType, funcSubType, funcRelId);
        return (SaasGrantDto)((Optional)grantCache.get((Object)key, () -> Optional.fromNullable((Object)remoteSaasGrantService.findGrant(new SaasGrantQueryParam(appId, funcType, funcSubType, funcRelId))))).orNull();
    }

    public static boolean isSaasItem(SaasFuncTypeEnum funcType, Integer funcSubType, Long funcRelId) {
        String key = funcType.getValue() + "_" + funcSubType + "_" + funcRelId;
        try {
            return (Boolean)saasItemCache.get((Object)key, () -> {
                SaasItemDto saasItem = remoteSaasItemSevice.findByUK(funcType, funcSubType, funcRelId);
                return saasItem != null && Boolean.TRUE.equals(saasItem.getOpenStatus());
            });
        }
        catch (ExecutionException e) {
            logger.warn("Saas\u5546\u54c1\u67e5\u8be2\u53d1\u751f\u5f02\u5e38, key:{},errmsg={}", (Object)key, (Object)e.getMessage());
            return false;
        }
    }

    public static boolean checkGrant(Long developerId, Long appId, SaasFuncTypeEnum funcType, Integer funcSubType, Long funcRelId, boolean degradedRunning) {
        if (appId == null) {
            return false;
        }
        if (SaasGrantUtil.canFreeUse(developerId, appId, true)) {
            return true;
        }
        if (!SaasGrantUtil.isSaasItem(funcType, funcSubType, funcRelId)) {
            return true;
        }
        try {
            SaasGrantDto saasGrant = SaasGrantUtil.getGrant(appId, funcType, funcSubType, funcRelId);
            if (saasGrant != null && (saasGrant.getDeadline() == null || DateUtils.daysBetween((Date)new Date(), (Date)saasGrant.getDeadline()) >= 0)) {
                return true;
            }
            Long visitCount = (Long)advancedCacheClient.get((Object)((Object)RedisKeyFactory.K005) + appId.toString());
            visitCount = visitCount == null ? 1L : visitCount;
            if (visitCount <= PROBATION_LIMIT_IN_DAY) {
                visitCount = visitCount + 1L;
                advancedCacheClient.set((Object)((Object)RedisKeyFactory.K005) + appId.toString(), (Object)visitCount, DateUtils.getToTomorrowSeconds(), TimeUnit.SECONDS);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.warn("\u6743\u9650\u6821\u9a8c\u53d1\u751f\u5f02\u5e38\uff0c\u662f\u5426\u964d\u7ea7\uff1a{}, appId={},errmsg={}", new Object[]{degradedRunning, appId, e.getMessage()});
            return degradedRunning;
        }
    }

    public static void setRemoteSaasGrantService(RemoteSaasGrantService remoteSaasGrantService) {
        SaasGrantUtil.remoteSaasGrantService = remoteSaasGrantService;
    }

    public static void setRemoteSaasDevFreeService(RemoteSaasDevFreeService remoteSaasDevFreeService) {
        SaasGrantUtil.remoteSaasDevFreeService = remoteSaasDevFreeService;
    }

    public static void setAdvancedCacheClient(AdvancedCacheClient advancedCacheClient) {
        SaasGrantUtil.advancedCacheClient = advancedCacheClient;
    }

    public static void setRemoteSaasItemSevice(RemoteSaasItemSevice remoteSaasItemSevice) {
        SaasGrantUtil.remoteSaasItemSevice = remoteSaasItemSevice;
    }

    public static RemoteAppNewExtraService getRemoteAppNewExtraService() {
        return remoteAppNewExtraService;
    }

    public static void setRemoteAppNewExtraService(RemoteAppNewExtraService remoteAppNewExtraService) {
        SaasGrantUtil.remoteAppNewExtraService = remoteAppNewExtraService;
    }

    static {
        PROBATION_LIMIT_IN_DAY = 100L;
        canFreeUseCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(1000L).build();
        accessAccountCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(1000L).build();
        grantCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(1000L).build();
        saasItemCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(1000L).build();
    }
}

