package cn.com.duiba.developer.center.api.domain.dto.saas.redpacketsmanagetool;


import cn.com.duiba.developer.center.api.domain.enums.saas.redpacketsmanagetool.ClearTimeTypeEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.redpacketsmanagetool.PerAmountLimitTypeEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.redpacketsmanagetool.StatusEnum;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by HePeng on 2018/10/29 16:39.
 */
public class RedpacketsManageToolDto implements Serializable {
    private static final long serialVersionUID = -8733341816220570895L;
    /**
     * 主键id
     */
    private Long id;
    /**
     * 应用id
     */
    private Long appId;
    /**
     * 状态
     */
    private StatusEnum statusEnum;
    /**
     * 单个用户提现额度限制
     */
    private PerAmountLimitTypeEnum perAmountLimitTypeEnum;
    /**
     * 限制额度（单位：分）
     */
    private Long perLimitAmount;
    /**
     * 获取提现次数类型 按bit计算：低位第1位-连续打开积分商城多少天，低位第2位-每月固定多少次
     * 参见: GainTimesTypeEnum类
     */
    private Integer gainTimesType;
    /**
     * 连续打开积分商城多少天加一次提现次数
     */
    private Integer visitMallDays;
    /**
     * 每月固定增加提现次数
     */
    private Integer addTimesMonthly;
    /**
     * 单个用户每月最多提现次数
     */
    private Integer perMaxTimesMonthly;
    /**
     * 红包清零时间点类型：1-每年最后一天，2-每月最后一天
     */
    private ClearTimeTypeEnum clearTimeTypeEnum;
    /**
     * 红包清零规则生效时间
     */
    private Date clearEffectTime;
    /**
     * 每日所有用户总提现限制额度（单位：分）
     */
    private Long maxAmountDaily;

    /**
     * 指定多个失效时间,json字符串
     */
    private String customizeExpireTimes;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public StatusEnum getStatusEnum() {
        return statusEnum;
    }

    public void setStatusEnum(StatusEnum statusEnum) {
        this.statusEnum = statusEnum;
    }

    public PerAmountLimitTypeEnum getPerAmountLimitTypeEnum() {
        return perAmountLimitTypeEnum;
    }

    public void setPerAmountLimitTypeEnum(PerAmountLimitTypeEnum perAmountLimitTypeEnum) {
        this.perAmountLimitTypeEnum = perAmountLimitTypeEnum;
    }

    public Long getPerLimitAmount() {
        return perLimitAmount;
    }

    public void setPerLimitAmount(Long perLimitAmount) {
        this.perLimitAmount = perLimitAmount;
    }

    public Integer getGainTimesType() {
        return gainTimesType;
    }

    public void setGainTimesType(Integer gainTimesType) {
        this.gainTimesType = gainTimesType;
    }

    public Integer getVisitMallDays() {
        return visitMallDays;
    }

    public void setVisitMallDays(Integer visitMallDays) {
        this.visitMallDays = visitMallDays;
    }

    public Integer getAddTimesMonthly() {
        return addTimesMonthly;
    }

    public void setAddTimesMonthly(Integer addTimesMonthly) {
        this.addTimesMonthly = addTimesMonthly;
    }

    public Integer getPerMaxTimesMonthly() {
        return perMaxTimesMonthly;
    }

    public void setPerMaxTimesMonthly(Integer perMaxTimesMonthly) {
        this.perMaxTimesMonthly = perMaxTimesMonthly;
    }

    public ClearTimeTypeEnum getClearTimeTypeEnum() {
        return clearTimeTypeEnum;
    }

    public void setClearTimeTypeEnum(ClearTimeTypeEnum clearTimeTypeEnum) {
        this.clearTimeTypeEnum = clearTimeTypeEnum;
    }

    public Date getClearEffectTime() {
        return clearEffectTime;
    }

    public void setClearEffectTime(Date clearEffectTime) {
        this.clearEffectTime = clearEffectTime;
    }

    public Long getMaxAmountDaily() {
        return maxAmountDaily;
    }

    public void setMaxAmountDaily(Long maxAmountDaily) {
        this.maxAmountDaily = maxAmountDaily;
    }

    public String getCustomizeExpireTimes() {
        return customizeExpireTimes;
    }

    public void setCustomizeExpireTimes(String customizeExpireTimes) {
        this.customizeExpireTimes = customizeExpireTimes;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
