package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Created by zyj on 2018/4/12.
 */
public enum SaasMallTypeEnum {
    /**
     * 积分商城类型
     */
    VIP_MALL(99, "兑吧VIP"),
    NOR_MALL(1, "标准版"),
    PRO_MALL(2, "专业版"),
    FLAG_MALL(3, "旗舰版"),
    EXTRAME_MALL(4, "至尊版");

    private static final Map<Integer, SaasMallTypeEnum> enumMap = new HashMap<>();

    static {
        for (SaasMallTypeEnum saasMallTypeEnum : values()) {
            enumMap.put(saasMallTypeEnum.getValue(), saasMallTypeEnum);
        }
    }

    public static SaasMallTypeEnum getByCode(Integer code) {
        SaasMallTypeEnum saasMallTypeEnum = enumMap.get(code);
        if (saasMallTypeEnum == null) {
            throw new DeveloperCenterException("不支持的积分商城类型");
        }
        return saasMallTypeEnum;
    }

    public static String getDesc(Integer code) {
        for (SaasMallTypeEnum each : SaasMallTypeEnum.values()) {
            if (Objects.equals(code, each.getValue())) {
                return each.getDesc();
            }
        }
        return "";
    }

    private int value;
    private String desc;

    SaasMallTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
