/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.utils;

import cn.com.duiba.developer.center.api.domain.enums.VipLimitTypeEnum;
import cn.com.duiba.developer.center.api.utils.VipLimitInfoGetter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class VipLimitFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean isFilterOpen;

    public VipLimitFilter() {
        this.isFilterOpen = false;
    }

    public VipLimitFilter(boolean isFilterOpen) {
        this.isFilterOpen = isFilterOpen;
    }

    public <T> void vipLimitFilter(Collection<T> collection, VipLimitInfoGetter<T> getter, Integer vipLevel) {
        if (!this.isFilterOpen) {
            return;
        }
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.canPassVipLimit(iterator.next(), getter, vipLevel)) continue;
            iterator.remove();
        }
    }

    public <T> boolean canPassVipLimit(T t, VipLimitInfoGetter<T> getter, Integer vipLevel) {
        if (VipLimitTypeEnum.OFF_LEVEL.getCode().equals(getter.getVipLimitType(t))) {
            return true;
        }
        if (getter.getVipLimits(t) == null) {
            return true;
        }
        long vipLevelLong = vipLevel.longValue();
        if (VipLimitTypeEnum.ABOVE_LEVEL.getCode().equals(getter.getVipLimitType(t))) {
            return vipLevelLong >= getter.getVipLimits(t);
        }
        if (VipLimitTypeEnum.ACCURATE_LEVEL.getCode().equals(getter.getVipLimitType(t))) {
            return this.isCanDo(getter.getVipLimits(t), vipLevelLong);
        }
        return false;
    }

    private boolean isCanDo(long vipLimits, long vipLevel) {
        long v = 1L << (int)vipLevel;
        long ret = vipLimits & v;
        return ret != 0L;
    }

    public boolean isFilterOpen() {
        return this.isFilterOpen;
    }
}

