package cn.com.duiba.developer.center.api.domain.dto.app;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.io.Serializable;

/**
 * @author JunAngLiu
 * @Title: AppExtraLargeFieldDto
 * @Description: app 分享代码
 * @date 2018/12/2719:54
 */
public class AppExtraLargeFieldDto implements Serializable {

    private static final long serialVersionUID = -3399578652734777984L;

    public static final int SwitchDevShareIos = 1; //是否开启ios分享开关
    public static final int SwitchDevShareAndroid = 2; // 是否开启android分享开关

    private Long id;
    /**
     * appId
     */
    private Long appId;

    /**
     * 分享开关
     */
    private Long shareSwitch;

    /**
     * ios 分享代码
     */
    private String shareIosCode;

    /**
     * android 分享代码
     */
    private String shareAndroidCode;


    /**
     * 用来判断开关位的状态
     * @param boundType 开关位
     * @return 是否开启
     */
    public boolean isShareSwitch(int boundType) {
        long v = 1 << boundType;
        long ret = shareSwitch & v;
        return ret != 0;
    }


    public Long getShareSwitch() {
        return shareSwitch;
    }

    public void setShareSwitch(Long shareSwitch) {
        this.shareSwitch = shareSwitch;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getShareIosCode() {
        return shareIosCode;
    }

    public void setShareIosCode(String shareIosCode) {
        this.shareIosCode = shareIosCode;
    }

    public String getShareAndroidCode() {
        return shareAndroidCode;
    }

    public void setShareAndroidCode(String shareAndroidCode) {
        this.shareAndroidCode = shareAndroidCode;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }
}
