package cn.com.duiba.developer.center.api.domain.dto.mainmeet;

import cn.com.duiba.developer.center.api.domain.enums.CLRewardRuleMatchEnum;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 集卡规则配置
 * Created by xiaoxuda on 2017/9/7.
 */
public class CLRewardRuleDto implements Serializable {
    private static final long serialVersionUID = 8219999373171717899L;

    /**
     * 奖励规则名称
     */
    private String rewardName;
    /**
     * 获奖规则集，保存获奖的所有条件
     */
    private List<CLRuleDto> rules;
    /**
     * 奖项配置，基本信息及获得该奖项的条件（是规则集的一个子集）
     */
    private List<CLRewardGradeDto> rewards;

    /**
     * 开启出奖模式
     */
    private Boolean openReward;

    /**
     * 获取给定数据匹配的奖励等级（rewards的数据序号，从1开始，返回0表示未中奖）
     *
     * @param entries
     * @return
     */
    public CLRewardGradeDto getMatchGrade(List<CLRewardGradeDto.Entry> entries) {
        if (CollectionUtils.isEmpty(entries)) {
            return null;
        }
        //顺序匹配奖项，匹配到即返回数据位置作为
        for (CLRewardGradeDto dto : rewards) {
            if (CLRewardRuleMatchEnum.ALL_MATCH.equals(dto.getType())) {
                if (allMatchValid(dto.getMatchs(), entries)) {
                    return dto;
                }
            }
        }
        return null;
    }

    /**
     * 全匹配规则中奖判断
     * @param matchs
     * @param entries
     * @return
     */
    public boolean allMatchValid(List<CLRewardGradeDto.Entry> matchs, List<CLRewardGradeDto.Entry> entries) {
        Map<String, Integer> paramMap = new HashMap<>();
        for(CLRewardGradeDto.Entry entry : entries){
            paramMap.put(entry.getKey(), entry.getVal());
        }
        for(CLRewardGradeDto.Entry rule : matchs){
            Integer val = paramMap.get(rule.getKey());
            if(val == null || val < rule.getVal()){
                return false;
            }
        }
        return true;
    }

    public String getRewardName() {
        return rewardName;
    }

    public void setRewardName(String rewardName) {
        this.rewardName = rewardName;
    }

    public List<CLRuleDto> getRules() {
        return rules;
    }

    public void setRules(List<CLRuleDto> rules) {
        this.rules = rules;
    }

    public List<CLRewardGradeDto> getRewards() {
        return rewards;
    }

    public void setRewards(List<CLRewardGradeDto> rewards) {
        this.rewards = rewards;
    }

    public Boolean getOpenReward() {
        return openReward;
    }

    public void setOpenReward(Boolean openReward) {
        this.openReward = openReward;
    }
}
