/**
 * Project Name:developer-center-api File Name:PushTypeEnum.java Package
 * Name:cn.com.duiba.developer.center.api.domain.enums Date:2016年11月2日下午9:44:03 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.developer.center.api.domain.enums;

import org.apache.commons.lang.StringUtils;

/**
 * 计划任务推送入口类型 <br/>
 * Date: 2016年11月2日 下午9:44:03 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public enum PushTypeEnum implements EnumInterface {

    PUSH_TO_BANNER("pushToBanner", "推送到banner列表"),

    PUSH_TO_ITEM("pushToItem", "推送到商品列表"),

    PUSH_TO_SHOWCASE("pushToShowcase", "推送到橱窗位");

    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private PushTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据主字段获取枚举类
     * @param code 枚举主字段
     * @return 枚举类
     */
    public static PushTypeEnum getByCode(String code) {
        for (PushTypeEnum enumVal : PushTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }
}
