package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zyj on 2018/5/22.
 */
public enum AgentSourceEnum {
    /**
     * 代理商来源
     * auditStatus
     */
    FROM_APPLY(1,"官网申请"),
    ADMIN_CREATE(2,"管理员创建");
    private static final Map<Integer, AgentSourceEnum> enumMap = new HashMap<>();
    static{
        for(AgentSourceEnum agentSourceEnum : values()){
            enumMap.put(agentSourceEnum.getValue(), agentSourceEnum);
        }
    }

    public static AgentSourceEnum getByCode(Integer code){
        AgentSourceEnum agentSourceEnum = enumMap.get(code);
        if(agentSourceEnum == null){
            throw new DeveloperCenterException("不支持的状态类型");
        }
        return agentSourceEnum;
    }

    private int    value;
    private String desc;

    AgentSourceEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
