package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zyj on 2018/4/12.
 */
public enum SaasOrderOperatTypeEnum {
    /**
     * 订单操作类型:1:通过;2:取消
     *
     */
    OPERATE_PASS(1,"通过"),
    OPERATE_CANCEL(2,"取消");

    private static final Map<Integer, SaasOrderOperatTypeEnum> enumMap = new HashMap<>();
    static{
        for(SaasOrderOperatTypeEnum saasOrderOperatTypeEnum : values()){
            enumMap.put(saasOrderOperatTypeEnum.getValue(), saasOrderOperatTypeEnum);
        }
    }
    public static SaasOrderOperatTypeEnum getByCode(Integer code){
        SaasOrderOperatTypeEnum saasOrderOperatTypeEnum = enumMap.get(code);
        if(saasOrderOperatTypeEnum == null){
            throw new DeveloperCenterException("不支持的订单操作类型");
        }
        return saasOrderOperatTypeEnum;
    }

    private int    value;
    private String desc;

    SaasOrderOperatTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
