/**
 * duiba-developer AmbDeveloperWithdrawCashOrderDAO.java
 * 
 * File Created at 2015年12月24日 下午8:03:11
 * $Id$
 *
 * Copyright 2015 duiba.com Croporation Limited.
 * All rights reserved.
 */
package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashOrderDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;


/**
 *
 * @create 2015年12月24日 下午8:03:11
 * @author Hermit
 * @version
 */
@AdvancedFeignClient
public interface RemoteAmbDeveloperWithdrawCashOrderService {
    /**
     * 查询
     * @param orderId
     * @return
     */
    AmbDeveloperWithdrawCashOrderDto findById(Long orderId);

    /**
     * 创建开发者撤回订单
     * @param ambDeveloperWithdrawCashOrderDto
     * @return
     */
    public DubboResult<AmbDeveloperWithdrawCashOrderDto> insert(AmbDeveloperWithdrawCashOrderDto ambDeveloperWithdrawCashOrderDto);


    /**
     * 获取订单分页列表
     * @param queryPamas(developerId,offset,max)
     * @return
     */
    public DubboResult<List<AmbDeveloperWithdrawCashOrderDto>> findCashOrderList(Map<String, Object> queryPamas);

    /**
     * 获取订单分页总数
     * @param queryPamas
     * @return
     */
    public DubboResult<Long> findCashOrderCount(Map<String, Object> queryPamas);

    /**
     * 将订单置为待支付状态
     * @param cashOrderId
     * @return
     */
    public DubboResult<Integer> updateStatusCreateToWaitPay(Long cashOrderId);

    /**
     * 将订单置为待失败状态
     * @param cashOrderId
     * @return
     */
    public DubboResult<Integer> updateStatusCreateToFail(Long cashOrderId);
    /**
     * 将订单置为待失败状态
     * @param cashOrderId
     * @return
     */
    Integer updateStatusToFail(Long cashOrderId, String message);
    /**
     * 将订单置为待成功状态
     * @param cashOrderId
     * @return
     */
    public DubboResult<Integer> updateStatusCreateToSuccess(Long cashOrderId);

    /**
     * 将订单置为异常状态
     * @param orderId
     * @return
     */
    int updateStatusToException(Long orderId, String message);

    /**
     * 捞出待自动转账的订单，最大每次取10个，默认取10个
     * @return
     */
    List<AmbDeveloperWithdrawCashOrderDto> findWaitAlipayTransferOrder(Integer limitCount);

    /**
     * 从新提交转账申请，状态置为wait_alipay_transfer，定时任务会自动扫描
     * @param orderId
     * @param message
     * @return
     */
    int retryRequestFundTransfer(Long orderId, String message);

    /**
     * 批量查询
     * @param cashOrderIds
     * @return
     */
    List<AmbDeveloperWithdrawCashOrderDto> findByIds(List<Long> cashOrderIds);
    
}
