package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.AppFloorTaskDto;
import cn.com.duiba.developer.center.api.domain.enums.StatusEnum;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by qianjue on 2017/11/17.
 */
@AdvancedFeignClient
public interface RemoteAppFloorTaskService {

	/**
	 * 新增楼层任务
	 * @param appFloorTaskDto
	 * @return
	 */
	DubboResult<Long> saveAppFloorTask(AppFloorTaskDto appFloorTaskDto);

	/**
	 * 编辑修改楼层任务
	 * @param appFloorTaskDto
	 * @return
	 */
	DubboResult<Long> updateAppFloorTask(AppFloorTaskDto appFloorTaskDto);

	/**
	 * 删除楼层任务
	 * @param taskId
	 * @param appId
	 * @return
	 */
	DubboResult<Boolean> deleteAppFloorTask(Long taskId,Long appId);

	/**
	 *
	 * @param appId  必传
	 * @param status 任务状态 null:查询所有
	 * @return
	 */
	DubboResult<List<AppFloorTaskDto>> queryTaskListByAppIdAndStatus(Long appId,StatusEnum status);

	/**
	 *
	 * @param appId
	 * @param taskId
	 * @param startPayload   开始位置
	 * @param endPayload     移动后的位置
	 * @return
	 */
	DubboResult<Boolean> sortAppTaskAndRange(Long appId, Long taskId, Integer startPayload,Integer endPayload);

	/**
	 *
	 * @param appId
	 * @param taskId
	 * @param statusEnum
	 * @return
	 */
	DubboResult<Boolean> updateAppFloorTaskStatus(Long appId,Long taskId,StatusEnum statusEnum);

	/**
	 *
	 * @param taskId
	 * @return
	 */
	DubboResult<AppFloorTaskDto> findAppFloorTaskById(Long taskId);
}
