package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.dcommons.domain.Tuple;
import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashAuditDto;
import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashOrderDto;
import cn.com.duiba.developer.center.api.domain.paramquery.WithdrawCashParams;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.javatuples.Pair;

/**
 * Created by ZQian on 2016/8/9.
 */
@AdvancedFeignClient
public interface RemoteDevWithdrawCashService {
    /**
     * 提现到银行卡或支付宝 首次或重新提交新材料审核
     * @param withdrawCashParams
     * @return
     * @throws Exception
     */
    @Deprecated
    DubboResult<Tuple.Tuple2<AmbDeveloperWithdrawCashAuditDto, AmbDeveloperWithdrawCashOrderDto>> firstWithdrawToBankOrAlipay(WithdrawCashParams withdrawCashParams) throws Exception;

    /**
     * 提现到银行卡或支付宝 首次或重新提交新材料审核
     * @param withdrawCashParams
     * @return
     * @throws Exception
     */
    DubboResult<Pair<AmbDeveloperWithdrawCashAuditDto, AmbDeveloperWithdrawCashOrderDto>> firstWithdrawToBankOrAlipayApi(WithdrawCashParams withdrawCashParams) throws Exception;

    /**
     * 更改单据状态
     * @param cashAuditDO
     * @param cashOrderDO
     * @throws Exception
     */
    void updateAuditAndOrderStatus(AmbDeveloperWithdrawCashAuditDto cashAuditDO,AmbDeveloperWithdrawCashOrderDto cashOrderDO) throws Exception;
}
