package cn.com.duiba.developer.center.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.DevDto;
import cn.com.duiba.developer.center.api.domain.dto.DeveloperBlacklistDto;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;
@AdvancedFeignClient
public interface RemoteDeveloperBlacklistService {

	public DubboResult<Integer> delete(Long id);

	public DubboResult<DeveloperBlacklistDto> findByDeveloperId(Long developerId);

	public DubboResult<PaginationVO<DeveloperBlacklistDto>> findPage(Map<String, Object> queryMap);

	/**
	 * 开发者黑名单待选列表
	 */
	public DubboResult<List<DevDto>> findDevVO(String queryInfo);

	/**
	 * 把开发者添加到黑名单中
	 */
	public DubboResult<Void> addDevIntoBlacklist(Long[] devIds);

	/**
	 * 获取所有在开发者黑名单中的appIds
	 */
	public DubboResult<List<Long>> getAllBlackAppIds();

	public DubboResult<List<DeveloperBlacklistDto>> findAll();
}
