package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zyj on 2018/5/18.
 */
public enum CommunicationProgressEnum {
    /**
     * 沟通进度
     * communicationProgress
     */
    WAIT_COMMUNICATION(1,"待沟通"),
    IN_COMMUNICATION(2,"初步沟通"),
    CLEAR_INTENTION(3,"意向明确"),
    INVALID(4,"无效");

    private static final Map<Integer, CommunicationProgressEnum> ENUM_MAP = new HashMap<>();
    static{
        for(CommunicationProgressEnum communicationProgressEnum : values()){
            ENUM_MAP.put(communicationProgressEnum.getValue(), communicationProgressEnum);
        }
    }

    public static CommunicationProgressEnum getByCode(Integer code){
        CommunicationProgressEnum communicationProgressEnum = ENUM_MAP.get(code);
        if(communicationProgressEnum == null){
            throw new DeveloperCenterException("不支持的进度类型");
        }
        return communicationProgressEnum;
    }

    private int    value;
    private String desc;

    CommunicationProgressEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
