package cn.com.duiba.developer.center.api.domain.dto;

import cn.com.duiba.developer.center.api.domain.BaseDO;
import cn.com.duiba.developer.center.api.domain.enums.ManualRechargeTypeEnum;

import java.util.Date;

/**
 * 手动变更申请单
 */
public class ManualChargeApplyDto extends BaseDO{
	private static final long serialVersionUID = -247230658677040611L;

	public static final String StatusCreate = "create"; //
	public static final String StatusSuccess = "success";// 
	public static final String StatusFail = "fail";// 
	public static final String StatusUnknow = "unknow"; //

	private Long id;
	private Long changeMoney;
	private String status;
	private String message;
	private Date finishTime;
	private Long developerId;
	private String memo;
	private Long adminId;
	private Date gmtCreate;
	private Date gmtModified;

	/**
	 * 开发者应用ID
	 */
	private Long appId;

	/**
	 *
	 * 充值方式，1:支付宝 2：微信,3:银行卡
	 * @see ManualRechargeTypeEnum
	 */
	private Integer rechargeType;

	/**
	 * 充值渠道流水号
	 */
	private String rechargeChannelSerial;

	/**
	 * 无参构造函数
	 */
	public ManualChargeApplyDto(){
		this.toBeUpdate = false;
		this.toBeInsert = false;
	}

	/**
	 * 更新构造函数
	 * @param id 实体Id
	 */
	public ManualChargeApplyDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}

	/**
	 * 插入构造函数
	 * @param init4insert
     */
	public ManualChargeApplyDto(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getAdminId()
	{
		return adminId;
	}

	public void setAdminId(Long adminId)
	{
		this.adminId = adminId;
	}

	public Long getDeveloperId()
	{
		return developerId;
	}

	public void setDeveloperId(Long developerId)
	{
		this.developerId = developerId;
	}

	public Long getChangeMoney()
	{
		return changeMoney;
	}

	public void setChangeMoney(Long changeMoney)
	{
		this.changeMoney = changeMoney;
	}

	public String getStatus()
	{
		return status;
	}

	public void setStatus(String status)
	{
		this.status = status;
	}

	public String getMessage()
	{
		return message;
	}

	public void setMessage(String message)
	{
		this.message = message;
	}

	public Date getFinishTime()
	{
		return finishTime;
	}

	public void setFinishTime(Date finishTime)
	{
		this.finishTime = finishTime;
	}

	public Date getGmtCreate()
	{
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate)
	{
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified()
	{
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getMemo()
	{
		return memo;
	}

	public void setMemo(String memo){
		this.memo = memo;
	}

	/**
	 * 重新设置更新标记
	 */
	public void setUpdateAgain(){
		super.toBeUpdate=true;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Integer getRechargeType() {
		return rechargeType;
	}

	public void setRechargeType(Integer rechargeType) {
		this.rechargeType = rechargeType;
	}

	public String getRechargeChannelSerial() {
		return rechargeChannelSerial;
	}

	public void setRechargeChannelSerial(String rechargeChannelSerial) {
		this.rechargeChannelSerial = rechargeChannelSerial;
	}
}
