package cn.com.duiba.developer.center.api.remoteservice.visualeditor;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.visualeditor.VisualEditorSkinUnitDto;
import cn.com.duiba.developer.center.api.domain.param.VisualEditorSkinUnitParam;
import cn.com.duiba.developer.center.api.domain.param.VisualUnitChangePrama;

import java.util.List;

/**
 * @author zhenghuan (zhenghuan@duiba.com.cn)
 * @date 2018/8/13 0013 10:32
 */
@AdvancedFeignClient
public interface RemoteVisualEditorSkinUnitService {
    public Long insert(VisualUnitChangePrama pojo);

    public int update(VisualUnitChangePrama pojo);

    public int delete(Long id);

    public List<VisualEditorSkinUnitDto> select(VisualEditorSkinUnitParam pojo);

    public Long count(VisualEditorSkinUnitParam pojo);

    /**
     * 根据id查找
     * 1.不过滤delete 即被软删除的数据也会返回
     *
     * @param id
     * @return
     */
    VisualEditorSkinUnitDto selectOne(Long id);

    VisualEditorSkinUnitDto selectOneByParam(VisualEditorSkinUnitParam pojo);

    /**
     * 根据传入的定向组件id 查询组件列表
     * 可选择是否包含通用组件
     *
     * @param param
     * @return
     */
    List<VisualEditorSkinUnitDto> selectDirectionList(VisualEditorSkinUnitParam param);
}
