package cn.com.duiba.developer.center.api.domain.dto;

import cn.com.duiba.developer.center.api.domain.enums.BusinessExportPlatformTypeEnum;
import cn.com.duiba.developer.center.api.domain.enums.BusinessExportStateEnum;
import cn.com.duiba.developer.center.api.domain.enums.BusinessExportTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * 业务功能导出记录
 * author zhanghuifeng
 * date 2018-12-06-14:10
 */
public class BusinessExportRecordDto implements Serializable {

    private static final long serialVersionUID = 3745398881130558651L;
    private Long id;

    /**
     * 导出条件内容
     */
    private String exportCondition;

    /**
     * 文件名
     */
    private String fileName;

    /**
     * 文件保存地址
     */
    private String fileUrl;

    /**
     * 操作人id,0:来自其它平台跳转登陆
     */
    private Long operatorId;

    /**
     * 业务功能导出结果状态
     * @see BusinessExportStateEnum
     */
    private Integer exportState;

    /**
     * 业务功能导出平台类型
     * @see BusinessExportPlatformTypeEnum
     */
    private Integer platformType;

    /**
     * 导出功能类型
     * @see BusinessExportTypeEnum
     */
    private Integer businessType;

    /**
     * 来源id:appId...
     */
    private Long sourceId;

    private Date gmtCreate;

    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getExportCondition() {
        return exportCondition;
    }

    public void setExportCondition(String exportCondition) {
        this.exportCondition = exportCondition;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public Integer getExportState() {
        return exportState;
    }

    public void setExportState(Integer exportState) {
        this.exportState = exportState;
    }

    public Integer getPlatformType() {
        return platformType;
    }

    public void setPlatformType(Integer platformType) {
        this.platformType = platformType;
    }

    public Integer getBusinessType() {
        return businessType;
    }

    public void setBusinessType(Integer businessType) {
        this.businessType = businessType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
