package cn.com.duiba.developer.center.api.domain.enums.forum;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zyj on 2018/5/18.
 */
public enum AnnouncementTypeEnum {
    /**
     * 公告类型
     */
    EXPAND_PRODUCT(1,"产品公告"),
    EXPAND_OPERATION(2,"运营公告");

    private static final Map<Integer, AnnouncementTypeEnum> ENUM_MAP = new HashMap<>();
    static{
        for(AnnouncementTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getValue(), typeEnum);
        }
    }

    public static AnnouncementTypeEnum getByCode(Integer code){
        return ENUM_MAP.get(code);
    }

    private int   value;
    private String desc;

    AnnouncementTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
