package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.DlpIncomeDetailDto;
import cn.com.duiba.developer.center.api.domain.dto.ManualChargeApplyDto;
import cn.com.duiba.developer.center.api.domain.dto.RechargeOrdersDto;
import cn.com.duiba.developer.center.api.domain.dto.RemainingMoneyDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by liuyao on 16/7/25.
 */
@AdvancedFeignClient
public interface RemoteDeveloperAccountService {
    /**
     * 获取开发者余额
     * @param developerId
     * @return
     */
    public DubboResult<RemainingMoneyDto> findRemainingMoney(Long developerId);

    /**
     * 获取开发者收入
     * @param developerId
     * @return
     */
    public DubboResult<DlpIncomeDetailDto> findIncomeDetail(Long developerId);

    /**
     * 查询在线充值订单
     * @param orderId
     * @return
     */
    public DubboResult<RechargeOrdersDto> findRechargeOrder(Long orderId);

    /**
     * 根据订单号查询订单
     * @param orderNum
     * @return
     */
    public DubboResult<RechargeOrdersDto> findByOrderNum(String orderNum);

    /**
     * 在线充值插入充值订单表
     * @param order
     * @return
     */
    public DubboResult<Long> addRechargeOrder(RechargeOrdersDto order);

    /**
     * 在线充值更新充值订单表
     * @param order
     * @return
     */
    public DubboResult<Long> updateRechargeOrder(RechargeOrdersDto order);

    /**
     * 查询开发者剩余额
     * @param developerId
     * @return
     */
    public DubboResult<RemainingMoneyDto> findDeveloperRemainingMoney(Long developerId);
    
    /**
     * 支付费用详情插入
     * @param manualChargeApplyDto
     * @return
     */
    DubboResult<Long> saveManualChargeApply(ManualChargeApplyDto manualChargeApplyDto);

    /**
     * 支付费用详情更新
     * @param manualChargeApplyDto
     * @return
     */
    DubboResult<Long> updateManualChargeApply(ManualChargeApplyDto manualChargeApplyDto);

    /**
     * 批量查询充值订单信息
     * @param ids
     * @return
     */
    List<RechargeOrdersDto> findRechargeOrderByIds(List<Long> ids);

    /**
     * 批量查询人工充值订单信息
     * @param ids
     * @return
     */
    List<ManualChargeApplyDto> findManualChargeApplyByIds(List<Long> ids);

    /**
     * 查询在线充值订单
     * @param orderId
     * @return
     */
    RechargeOrdersDto findNewRechargeOrder(Long orderId);

    /**
     *
     * @param rechargeChannelSerial
     * @param rechargeType
     * @see cn.com.duiba.developer.center.api.domain.enums.ManualRechargeTypeEnum
     * @return
     */
    List<ManualChargeApplyDto> findManualChargeByChargeTypeAndSerial(String rechargeChannelSerial,Integer rechargeType);

    /**
     * 根据充值渠道流水号查询充值信息
     * @param rechargeChannelSerial
     * @return
     */
    ManualChargeApplyDto findManualChargeByChargeSerial(String rechargeChannelSerial);
}
