/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.aspectj;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.DeveloperDto;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.apache.commons.beanutils.BeanUtilsBean2;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class Aspect4RemoteAppService {
    private Logger logger = LoggerFactory.getLogger(Aspect4RemoteAppService.class);
    private AdvancedCacheClient advancedCacheClient;
    private static Cache<Long, AppSimpleDto> appCache = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).build();
    private static Cache<String, Long> key2IdCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private static Cache<Long, DeveloperDto> developerCache = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).build();

    private static String getKeyByAppId(Long appId) {
        return "dcm_key_appId_" + appId;
    }

    private static String getKeyByDeveloperId(Long developerId) {
        return "dcm_keyDeveloperIdNew_" + developerId;
    }

    private AppSimpleDto getApp(Long appId) {
        AppSimpleDto result = (AppSimpleDto)this.cloneObj(appCache.getIfPresent((Object)appId));
        if (result == null && this.advancedCacheClient != null && (result = (AppSimpleDto)this.advancedCacheClient.get(Aspect4RemoteAppService.getKeyByAppId(appId))) != null) {
            appCache.put((Object)appId, (Object)result);
            key2IdCache.put((Object)result.getAppKey(), (Object)appId);
        }
        return result;
    }

    private AppSimpleDto getApp(String appKey) {
        AppSimpleDto result = null;
        Long appId = (Long)key2IdCache.getIfPresent((Object)appKey);
        if (appId != null) {
            result = this.getApp(appId);
        }
        return result;
    }

    private DeveloperDto getDeveloperById(Long developerId) {
        DeveloperDto result = (DeveloperDto)this.cloneObj(developerCache.getIfPresent((Object)developerId));
        if (result == null && this.advancedCacheClient != null && (result = (DeveloperDto)this.advancedCacheClient.get(Aspect4RemoteAppService.getKeyByDeveloperId(developerId))) != null) {
            developerCache.put((Object)developerId, (Object)result);
        }
        return result;
    }

    @Around(value="execution(* cn.com.duiba.developer.center.api.remoteservice.RemoteAppService.getSimpleApp(..))")
    public Object aroundGetSimpleApp(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Long appId = (Long)proceedingJoinPoint.getArgs()[0];
        Object result = this.getApp(appId);
        result = result != null ? DubboResult.successResult((Object)result) : proceedingJoinPoint.proceed();
        return result;
    }

    @Around(value="execution(* cn.com.duiba.developer.center.api.remoteservice.RemoteAppService.getAppByAppKey(..))")
    public Object aroundGetAppByAppKey(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        String appKey = (String)proceedingJoinPoint.getArgs()[0];
        Object result = this.getApp(appKey);
        result = result != null ? DubboResult.successResult((Object)result) : proceedingJoinPoint.proceed();
        return result;
    }

    @Around(value="execution(* cn.com.duiba.developer.center.api.remoteservice.RemoteDeveloperService.getDeveloperById(..))")
    public Object aroundGetDeveloperById(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Long developerId = (Long)proceedingJoinPoint.getArgs()[0];
        Object result = this.getDeveloperById(developerId);
        result = result != null ? DubboResult.successResult((Object)result) : proceedingJoinPoint.proceed();
        return result;
    }

    public void setAdvancedCacheClient(AdvancedCacheClient advancedCacheClient) {
        this.advancedCacheClient = advancedCacheClient;
    }

    private <T> T cloneObj(T t) {
        Object result;
        if (t == null) {
            return t;
        }
        try {
            result = BeanUtilsBean2.getInstance().cloneBean(t);
        }
        catch (Exception e) {
            result = t;
            this.logger.info("Aspect4RemoteAppService.cloneObj failed", (Object)e.getMessage());
        }
        return (T)(result == null ? t : result);
    }
}

