package cn.com.duiba.developer.center.api.remoteservice.risk;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.risk.RiskWhiteListDto;
import cn.com.duiba.developer.center.api.domain.enums.risk.RiskWhiteListSenceEnum;
import cn.com.duiba.developer.center.api.domain.param.RiksWhitelistMatchingParam;
import cn.com.duiba.developer.center.api.domain.param.RiskWhiteListParam;

/**
 * @author JunAngLiu
 * @Title: RemoteRiskWhiteListService
 * @Description: 风控白名单
 * @date 2019/6/1821:25
 */
@AdvancedFeignClient
public interface RemoteRiskWhiteListService {


    //新增
    int insert(RiskWhiteListDto dto)throws BizException;


    //根据主键修改
    int updateById(RiskWhiteListDto dto);

    /**
     * 条件查询list
     * @param param
     * @return
     */
    Page<RiskWhiteListDto> listByAppConsumerTypeSences(RiskWhiteListParam param);

    /**
     * 校验 是否在通过白名单(3.5.5版本进行废弃，因为增加了一层IP维度的白名单，所以请尽快更换)
     * {@link cn.com.duiba.developer.center.api.remoteservice.risk.RemoteRiskWhiteListService#riskWhitelistMatching}
     * @param appId
     * @param consumerId
     * @param riskSence
     * @return
     */
    @Deprecated
    Boolean exsist(Long appId, Long consumerId, RiskWhiteListSenceEnum riskSence)throws BizException;


    /**
     * 新白名单匹配接口
     * @param riksWhitelistMatchingParam 请求参数类
     * @return 是否匹配到白名单 True/False
     */
    Boolean riskWhitelistMatching(RiksWhitelistMatchingParam riksWhitelistMatchingParam)throws BizException;
}
