/**
 * Project Name:developer-center-api
 * File Name:AppPushStatusEnum.java
 * Package Name:cn.com.duiba.developer.center.api.domain.enums
 * Date:2016年11月2日下午9:51:11
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.api.domain.enums.authority;

import com.google.common.collect.Lists;

import java.util.List;
import java.util.Objects;

/**
 * 针对基础服务/会员营销的权限新增都要在这么配置一个类型
 * 基础服务从5000000开始新增
 * 会员营销从6000000开始新增
 * <br/>
 */
public enum RightTypeEnum {

    /**
     * 基础服务从5000000开始新增<br/>
     */
//    BASIC_SERVICE(5000000,"基础服务"),


    /**
     * 会员营销从9000000开始新增<br/>
     */
    PLUS_RIGHT(6000000L,"全局色配置"),
    ;


    private Long resourcesTag;
    private String desc;

    RightTypeEnum(Long resourcesTag, String desc) {
        this.resourcesTag = resourcesTag;
        this.desc = desc;
    }

    private static List<Long> allKey = null;

    public Long getResourcesTag() {
        return resourcesTag;
    }

    public void setResourcesTag(Long resourcesTag) {
        this.resourcesTag = resourcesTag;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static List<Long> getAllKeyValues(){
        if(allKey != null){
            return allKey;
        }
        List<Long> allKeys = Lists.newArrayList();
        for(RightTypeEnum data: RightTypeEnum.values()){
            allKeys.add(data.getResourcesTag());
        }
        allKey = allKeys;
        return allKey;
    }


    public static RightTypeEnum getByValue(Long value){
        if(value == null){
            return null;
        }
        for(RightTypeEnum rightTypeEnum:RightTypeEnum.values()){
            if(Objects.equals(rightTypeEnum.getResourcesTag(),value) ){
                return rightTypeEnum;
            }
        }
        return null;
    }

}

