/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.utils;

import cn.com.duiba.developer.center.api.DeveloperCenterException;
import cn.com.duiba.developer.center.api.utils.MD5;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DBcongfigFileContext {
    private Splitter spl = Splitter.on((String)"\n").omitEmptyStrings();
    private Joiner joiner = Joiner.on((String)"\n").skipNulls();
    private static final String CONTEXT_KEY = "duiba:config";
    private static final String END = "</duiba:config>";
    private Multimap<String, String> LINE_MAP = LinkedListMultimap.create();
    private String curreryId;

    protected void addLine(String line) {
        if (StringUtils.isBlank((String)line)) {
            return;
        }
        if (line.contains("duiba:config id")) {
            if (StringUtils.isNotBlank((String)this.curreryId)) {
                throw new DeveloperCenterException("duibaconfig\u6587\u4ef6\u975e\u95ed\u5408");
            }
            this.curreryId = this.getId(line);
            return;
        }
        if (line.contains(END)) {
            if (StringUtils.isBlank((String)this.curreryId)) {
                throw new DeveloperCenterException("duibaconfig\u6587\u4ef6\u975e\u95ed\u5408");
            }
            this.curreryId = null;
            return;
        }
        this.LINE_MAP.put((Object)this.curreryId, (Object)line);
    }

    private List<String> toStringList() {
        ArrayList lines = Lists.newArrayList();
        for (String id : this.LINE_MAP.keySet()) {
            lines.add(this.getConfigPre(id));
            lines.addAll(this.LINE_MAP.get((Object)id));
            lines.add(END);
        }
        return lines;
    }

    public int put(String id, String code) {
        if (StringUtils.isBlank((String)id)) {
            throw new DeveloperCenterException("duibaconfig\u6587\u4ef6\u952e\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)code)) {
            return 0;
        }
        if (code.contains(CONTEXT_KEY)) {
            throw new DeveloperCenterException("duibaconfig\u6587\u4ef6\u7684\u5185\u5bb9\u4e0d\u80fd\u5305\u542b\u5173\u952e\u5b57\u7b26");
        }
        if (this.LINE_MAP.containsKey((Object)id)) {
            this.LINE_MAP.removeAll((Object)id);
        }
        List lines = this.spl.splitToList((CharSequence)code);
        this.LINE_MAP.putAll((Object)id, (Iterable)lines);
        return lines.size();
    }

    public int remove(String id) {
        if (!this.LINE_MAP.containsKey((Object)id)) {
            return 0;
        }
        int count = this.LINE_MAP.get((Object)id).size();
        this.LINE_MAP.removeAll((Object)id);
        return count;
    }

    public String get(String id) {
        if (!this.LINE_MAP.containsKey((Object)id)) {
            return "";
        }
        return this.joiner.join((Iterable)this.LINE_MAP.get((Object)id));
    }

    public boolean contains(String key) {
        return this.LINE_MAP.containsKey((Object)key);
    }

    public void toFile(File file) {
        try {
            CharSink sink = Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]);
            List<String> lines = this.toStringList();
            sink.writeLines(lines);
        }
        catch (Exception e) {
            throw new DeveloperCenterException("duibaconfig\u6587\u4ef6\u5185\u5bb9\u8f6c\u50a8\u5931\u8d25", e);
        }
    }

    public String md5() {
        List<String> lines = this.toStringList();
        return MD5.md5(this.joiner.join(lines));
    }

    private String getConfigPre(String id) {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(CONTEXT_KEY).append(" ").append("id=\"").append(id).append("\">");
        return sb.toString();
    }

    private String getId(String line) {
        int bigin = line.indexOf("\"");
        int end = line.lastIndexOf("\"");
        return line.substring(bigin + 1, end);
    }
}

