package cn.com.duiba.developer.center.api.domain.dto;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

/**
 * Created by liuyao on 16/7/28.
 */
public class AppSimpleDto implements Serializable {
    private static final long serialVersionUID = -2727327703409654191L;

    public static final int BoundAlipay = 0; // 支付宝账号绑定
    public static final int BoundQQ = 1; // QB号码绑定
    public static final int BoundPhone = 2; // 手机号码绑定
    public static final int SwitchOpenVipLimit = 3; // 是否开启会员限制
    public static final int SwitchOpenShare = 4;	// 是否开启分享功能
    public static final int SwitchCodeEdit = 5;//是否开启代码编辑
    public static final int SwitchCloseClientAlarm = 6;//是否关闭客户端未使用源码警示
    public static final int SwitchCloseAppTradingLimit = 7;//是否开启APP交易限制
    public static final int SwitchCreditsDecimalPoint  = 8;//是否开启提供人民币格式展示
    public static final int SwitchShowcasePlace1 = 9;	// 橱窗位1
    public static final int SwitchShowcasePlace2 = 10;	// 橱窗位2
    public static final int SwitchShowcasePlace3 = 11;	// 橱窗位3
    public static final int SwitchCloseCreditsType  = 12;//是否开启积分模式
    public static final int SwitchUseLoginCode  = 13;//是否开启定制唤起登录
    public static final int SwitchFreeItemVip = 14;//开启兑吧免费商品设置会员等级
    public static final int SwitchExchangeCreditsType = 16;//可编辑抽奖积分
    public static final int SwitchOpenBulletin = 15;//开启首页公示条
    public static final int SwitchPlatformCouponType = 17;//开启或关闭券库
    public static final int SwitchMallCreditsType = 18;//是否开启无积分商城模式,0否,1是
    public static final int SwitchShareProgramType = 19;//分享对接代码
    public static final int SwitchNoAbutmentType = 20;	//免技术对接
    public static final int SwitchCanUseCustomSign = 21;//能否使用自定义签到
    public static final int SwitchNavHeader = 22;//是否开启导航栏
    public static final int SwitchCloseCrecordKeFu=24;//是否关闭客服,因为该功能默认开启,23在测试数据中有被使用过的痕迹,保险起见跳过
    public static final int SwitchFlowRuleRecordVisible=25;//是否关闭流量策略订单可见性,该功能默认开启
    public static final int SwitchTransforFuDai=26;//谢谢参与转福袋开关，默认关闭，若开启后，则该应用的自有活动中谢谢参与后都转成福袋
    public static final int SwitchForbidApp = 27;//禁用app,兑吧全平台针对该app的访问都返回一个系统暂不可用的页面
    public static final int SwitchCloseRecommend = 28; //App层次是否关闭推荐,默认开启,注意表达格式
    public static final int SwitchOpenRemainStock = 29; //商品是否开启库存展示,默认关闭
    public static final int SwitchAddVisterTime = 30; //是否自行增加用户免费抽奖次数,默认关闭
    public static final int SwitchVirOrderRetry = 31; // 是否开启虚拟商品重试页面开关,默认关闭
    public static final int SwitchShoppingCart = 32; //是否开启购物车，默认关闭

    private Long id;
    private Long developerId;//开发者Id
    private String name;//app名称
    private String title;
    private String appKey;//应用唯一标识
    private Integer creditsRate;// 积分兑换金钱的比例 1元对应多少个积分
    private Boolean enable;
    private Boolean bannerEnable;
    private Boolean buttonEnable;
    private String unitName; // 自定义积分单位名称（默认为‘积分’）
    private Integer showItemNum; // 最多展示的兑换项数量 目前分为三档 15 20 25个 默认展示20个

    private Boolean autoRecommend;//自动推荐 默认关闭
    private Long appSwitch;

    private String appSecret;//调用RemoteAppService.getSimpleApp获取的对象可得到此变量

    private String logo;
    private String color;
    private Boolean sendSecret;
    private String category1;
    private String category2;
    private Date newItemTime;//最新查看兑吧商品时间
    // APP会员等级配置
    private String vipLevelConfig;

    private String earnCreditsUrl;//赚取积分链接
    private String recordNotifyUrl;//兑换记录通知链接
    private String virtualExchangeUrl; //虚拟商品充值接口
    private String creditsRemainQueryUrl;// ;积分余额查询地址
    private String creditsConsumeRequestUrl; // 积分扣除地址
    private String creditsConsumeNotifyUrl; // 积分消耗的结果通知地址

    private Date gmtCreate;
    private Date gmtModified;

    /**
     * 是否具有开发能力
     */
    private Integer developAbility;

    private Integer createSource;//该条数据来源，0：兑吧 or 1：推啊

    //业务主体
    private String subject;
    //更新业务主体的时间
    private Date modifiedSubjectTime;

    /**
     * 用来判断开关位的状态
     * @param boundType 开关位
     * @return 是否开启
     */
    public boolean isAppSwitch(int boundType) {
        long v = 1 << boundType;
        long ret = appSwitch & v;
        return ret != 0;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getDeveloperId() {
        return developerId;
    }

    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    public String getCategory2() {
        return category2;
    }

    public void setCategory2(String category2) {
        this.category2 = category2;
    }

    public String getCategory1() {
        return category1;
    }

    public void setCategory1(String category1) {
        this.category1 = category1;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public Boolean getSendSecret() {
        return sendSecret;
    }

    public void setSendSecret(Boolean sendSecret) {
        this.sendSecret = sendSecret;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Date getNewItemTime() {
        return newItemTime;
    }

    public void setNewItemTime(Date newItemTime) {
        this.newItemTime = newItemTime;
    }

    public String getVipLevelConfig() {
        return vipLevelConfig;
    }

    public void setVipLevelConfig(String vipLevelConfig) {
        this.vipLevelConfig = vipLevelConfig;
    }

    public String getEarnCreditsUrl() {
        return earnCreditsUrl;
    }

    public void setEarnCreditsUrl(String earnCreditsUrl) {
        this.earnCreditsUrl = earnCreditsUrl;
    }

    public String getRecordNotifyUrl() {
        return recordNotifyUrl;
    }

    public void setRecordNotifyUrl(String recordNotifyUrl) {
        this.recordNotifyUrl = recordNotifyUrl;
    }

    public String getVirtualExchangeUrl() {
        return virtualExchangeUrl;
    }

    public void setVirtualExchangeUrl(String virtualExchangeUrl) {
        this.virtualExchangeUrl = virtualExchangeUrl;
    }

    public String getCreditsRemainQueryUrl() {
        return creditsRemainQueryUrl;
    }

    public void setCreditsRemainQueryUrl(String creditsRemainQueryUrl) {
        this.creditsRemainQueryUrl = creditsRemainQueryUrl;
    }

    public String getCreditsConsumeRequestUrl() {
        return creditsConsumeRequestUrl;
    }

    public void setCreditsConsumeRequestUrl(String creditsConsumeRequestUrl) {
        this.creditsConsumeRequestUrl = creditsConsumeRequestUrl;
    }

    public String getCreditsConsumeNotifyUrl() {
        return creditsConsumeNotifyUrl;
    }

    public void setCreditsConsumeNotifyUrl(String creditsConsumeNotifyUrl) {
        this.creditsConsumeNotifyUrl = creditsConsumeNotifyUrl;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public Integer getCreditsRate() {
        return creditsRate;
    }

    public void setCreditsRate(Integer creditsRate) {
        this.creditsRate = creditsRate;
    }

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Integer getShowItemNum() {
        return showItemNum;
    }

    public void setShowItemNum(Integer showItemNum) {
        this.showItemNum = showItemNum;
    }

    public Boolean getAutoRecommend() {
        return autoRecommend;
    }

    public void setAutoRecommend(Boolean autoRecommend) {
        this.autoRecommend = autoRecommend;
    }

    public Long getAppSwitch() {
        return appSwitch;
    }

    public void setAppSwitch(Long appSwitch) {
        this.appSwitch = appSwitch;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public Boolean getBannerEnable() {
        return bannerEnable;
    }

    public void setBannerEnable(Boolean bannerEnable) {
        this.bannerEnable = bannerEnable;
    }

    public Boolean getButtonEnable() {
        return buttonEnable;
    }

    public void setButtonEnable(Boolean buttonEnable) {
        this.buttonEnable = buttonEnable;
    }

    public Integer getDevelopAbility() {
        return developAbility;
    }

    public void setDevelopAbility(Integer developAbility) {
        this.developAbility = developAbility;
    }

    public Integer getCreateSource() {
        return createSource;
    }

    public void setCreateSource(Integer createSource) {
        this.createSource = createSource;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Date getModifiedSubjectTime() {
        return modifiedSubjectTime;
    }

    public void setModifiedSubjectTime(Date modifiedSubjectTime) {
        this.modifiedSubjectTime = modifiedSubjectTime;
    }

    /**
     * 判断app的接口是否配置完整,从而设置该App是否可以启用
     */
    public void checkApiEnableUpdate() {
        gmtModified = new Date();
        if (creditsConsumeRequestUrl == null || creditsConsumeRequestUrl.trim().length() == 0 || creditsConsumeNotifyUrl == null || creditsConsumeNotifyUrl.trim().length() == 0) {
            enable = false;
        } else {
            enable = true;
        }
    }

    /**
     * 根据会员等级得到对应的会员名称
     * @param level 用户会员等级
     * @return 会员等级的名称
     */
    public String getLevelName(Integer level) {
        Map<Long, String> config = this.getVipLevelConfigMap();
        if(config.containsKey(level.longValue())){
            return config.get(level.longValue());
        }else{
            return config.get(0);
        }
    }

    /**
     * 获取会员等级map对象
     * @return 会员等级配置
     */
    public Map<Long,String> getVipLevelConfigMap(){
        if(StringUtils.isBlank(this.getVipLevelConfig())){
            return Collections.emptyMap();
        }
        JSONArray jsonArray = JSONArray.parseArray(this.getVipLevelConfig());
        //优化点
        Map<Long,String> map = Maps.newHashMap();
        for(int i =0;i<jsonArray.size();i++){
            JSONObject json = jsonArray.getJSONObject(i);
            map.put(json.getLong("level"),json.getString("name"));
        }
        return map;
    }

}
