package cn.com.duiba.developer.center.api.domain.enums.customerService;

/**
 * Created by xutao on 2018/3/19.
 */
public enum CustomerMsgSourceEnum {
    SELF(1,"直达区"),
    URL_TEXT(2,"文字链");

    private Integer code;
    private String desc;

    CustomerMsgSourceEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static String getDescByCode(Integer code){
        if(code == null){
            return null;
        }

        for (CustomerMsgSourceEnum sourceEnum : CustomerMsgSourceEnum.values()) {
            if (sourceEnum.code.intValue() == code) {
                return sourceEnum.getDesc();
            }
        }
        return null;
    }
}
