package cn.com.duiba.developer.center.api.domain.dto;


import java.io.Serializable;
import java.util.Date;

/**
 * 开发者加钱购订单
 */
public class AmbDeveloperWithdrawCashOrderDto implements Serializable {
	private static final long serialVersionUID = 4482465642249775705L;

	public static final String StatusCreate = "create"; //NOSONAR

	public static final String StatusWaitPay = "wait_pay";//NOSONAR

	public static final String StatusSucess = "success";//NOSONAR

	public static final String StatusFail = "fail";//NOSONAR

	/**
	 * 自动转账专用
	 */
	public static final String StatusWaitAlipayTransfer = "wait_alipay_transfer";//NOSONAR

	/**
	 * 异常状态提现申请，要慎重对待，不能自动将订单置为失败，需要财务介入处理
	 */
	public static final String StatusException = "exception";//NOSONAR

	private Long id;

	private Long developerId;

	private Long money;

	private String status;

	private String description;

	private String memo;

	private Long auditId;

	private Boolean requiredAudit;

	private Date gmtCreate;

	private Date gmtModified;

	/**
	 * 开发者应用ID
	 */
	private Long appId;

	/**
	 * 用户员工id（用户唯一标示）
	 */
	private Long employeeId;

	/**
	 * 创建构造函数
	 * @param init4insert
	 */
	public AmbDeveloperWithdrawCashOrderDto(boolean init4insert) {
		if (init4insert) {
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}

	/**
	 * 更新构造函数
	 * @param id
	 */
	public AmbDeveloperWithdrawCashOrderDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	/**
	 * 无参构造函数
	 */
	public AmbDeveloperWithdrawCashOrderDto() {
		super();
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getDeveloperId() {
		return developerId;
	}

	public void setDeveloperId(Long developerId) {
		this.developerId = developerId;
	}

	public Long getMoney() {
		return money;
	}

	public void setMoney(Long money) {
		this.money = money;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	public Long getAuditId() {
		return auditId;
	}

	public void setAuditId(Long auditId) {
		this.auditId = auditId;
	}

	public Boolean getRequiredAudit() {
		return requiredAudit;
	}

	public void setRequiredAudit(Boolean requiredAudit) {
		this.requiredAudit = requiredAudit;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getEmployeeId() {
		return employeeId;
	}

	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}
}