package cn.com.duiba.developer.center.api.remoteservice.innerpage;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.innerpage.InnerPageCustomSkinDto;
import cn.com.duiba.developer.center.api.domain.paramquery.InnerPageCusSkinParams;

import java.util.List;

/**
 * Created by xutao on 2020/2/4.
 */
@AdvancedFeignClient
public interface RemoteInnerPageCustomSkinService {
    /**
     * 根据Id查询皮肤
     * @return 皮肤
     */
    InnerPageCustomSkinDto findById(Long id) throws BizException;

    /**
     * 管理员端 列表页查询
     * @param param
     * @return
     */
    List<InnerPageCustomSkinDto> findPage(InnerPageCusSkinParams param);

    /**
     * 新增或者更新皮肤信息
     * @param dto
     * @return
     */
    InnerPageCustomSkinDto saveOrUpdate(InnerPageCustomSkinDto dto) throws BizException;

    /**
     * 查询数据库条数
     * @param param
     * @return
     */
    Integer findPageCount(InnerPageCusSkinParams param);

    /**
     *
     * showOrHiddenBrick:(这里用一句话描述这个方法的作用). <br/>
     * 展示或者隐藏皮肤
     * @param id
     * @param status  0：关闭，1：开启
     * @return
     * @since JDK 1.6
     */
    Integer showOrHiddenCustomSkin(Long id, Integer status);

    /**
     * 根据ids查询皮肤
     *
     * @param ids
     * @return
     */
    List<InnerPageCustomSkinDto> batchFindByIds(List<Long> ids);

    /**
     * 根据Id查询皮肤
     * @return 皮肤
     */
    Integer deleteById(Long id);

    InnerPageCustomSkinDto findByPath(String path, Boolean showContent);
}
