package cn.com.duiba.developer.center.api.domain.dto.strategy;

import java.io.Serializable;
import java.util.Date;

/**
 * 案例
 *
 * @Author: xuwei
 * @Date: 2020/05/27
 */
public class StrategyCaseDto implements Serializable {

    private static final long serialVersionUID = 258805704060707955L;

    /**
     * 属性-视觉稿图片
     */
    public static final String ATTR_VISUAL_IMAGE = "visual_image";
    /**
     * 属性-入口图片
     */
    public static final String ATTR_ENTRY_IMAGE = "entry_image";
    /**
     * 属性-满意度
     */
    public static final String ATTR_SATISFACTION = "satisfaction";

    /**
     * 状态-下线
     */
    public static final int STATUS_OFF = 0;
    /**
     * 状态-上线
     */
    public static final int STATUS_ON = 1;

    /**
     * 预览开关
     */
    public static final int SWITCH_PREVIEW = 0;

    /**
     * ID
     */
    private Long id;

    /**
     * 名称
     */
    private String name;

    /**
     * 应用ID
     */
    private Long appId;

    /**
     * 关联活动标识
     */
    private String activityId;

    /**
     * 行业
     *
     * @see {@link cn.com.duiba.developer.center.api.domain.enums.StrategyDynamicDataTypeEnum#INDUSTRY}
     */
    private Long industry;

    /**
     * 行业分类
     *
     * @see {@link cn.com.duiba.developer.center.api.domain.enums.StrategyDynamicDataTypeEnum#INDUSTRY_TYPE}
     */
    private Long industryType;

    /**
     * 客户
     *
     * @see {@link cn.com.duiba.developer.center.api.domain.enums.StrategyDynamicDataTypeEnum#CUSTOMER}
     */
    private Long customer;

    /**
     * 经营指标，json数组
     * @see {@link cn.com.duiba.developer.center.api.domain.enums.StrategyDynamicDataTypeEnum#INDICATOR}
     */
    private String indicators;

    /**
     * 玩法类型
     *
     * @see {@link cn.com.duiba.developer.center.api.domain.enums.StrategyDynamicDataTypeEnum#PLAYWAY_TYPE}
     */
    private Long playwayType;

    /**
     * 玩法名称
     */
    private String playwayName;

    /**
     * 玩法组件，json数组
     * @see {@link cn.com.duiba.developer.center.api.domain.enums.StrategyDynamicDataTypeEnum#PLAYWAY_MODULE}
     */
    private String playwayModules;

    /**
     * 玩法简介
     */
    private String playwayText;

    /**
     * 视觉稿地址
     */
    private String visualUrl;

    /**
     * 需求地址
     */
    private String demandUrl;

    /**
     * 投放渠道
     * @see {@link cn.com.duiba.developer.center.api.domain.enums.StrategyDynamicDataTypeEnum#CHANNEL}
     */
    private Long channel;

    /**
     * 投放位置
     */
    private String position;

    /**
     * 入口文案
     */
    private String entryText;

    /**
     * 面向用户，json数组
     * @see {@link cn.com.duiba.developer.center.api.domain.enums.StrategyDynamicDataTypeEnum#USER_TYPE}
     */
    private String userTypes;

    /**
     * 用户场景
     */
    private String userScenario;

    /**
     * 推广模式
     */
    private String marketingMode;

    /**
     * 触达模式
     */
    private String reachMode;

    /**
     * 客户预算
     */
    private String customerBudget;

    /**
     * 数据模板
     *
     * @see {@link cn.com.duiba.developer.center.api.domain.enums.StrategyDynamicDataTypeEnum#TEMPLATE}
     */
    private Long templateId;

    /**
     * 预期目标，json数组
     * @see {@link cn.com.duiba.developer.center.api.domain.enums.StrategyDynamicDataTypeEnum#EXPECT_GOAL}
     */
    private String expectGoals;

    /**
     * 客户满意度评分
     */
    private String satisfactionGrade;

    /**
     * 客户满意度调查文件url
     */
    private String satisfactionUrl;

    /**
     * 有效性 0:待判定 1:有效 2:无效
     */
    private Integer validation;

    /**
     * 有效性判定描述
     */
    private String validationText;

    /**
     * 客户预期数据
     */
    private String expectData;

    /**
     * 案例PPT地址
     */
    private String pptUrl;

    /**
     * 状态 0:下线 1:上线
     */
    private Integer status;

    /**
     * 位开关，每一位表示一个功能开关，1表示开，0表示关
     */
    private Long switches = 0L;

    /**
     * 删除状态 0:未删除 1:删除
     */
    private Boolean deleted;

    /**
     * 创建者姓名
     */
    private String creater;

    /**
     * 最后更新者姓名
     */
    private String modifiedUser;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 视觉图片列表
     */
    private String visualImages;

    /**
     * 入口图片列表
     */
    private String entryImages;

    /**
     * 满意度列表
     */
    private String satisfactions;

    /**
     * 开启开关
     *
     * @param offset 位偏移量
     */
    public void openSwitch(int offset) {
        switches |= (1L << offset);
    }

    /**
     * 关闭开关
     *
     * @param offset 位偏移量
     */
    public void closeSwitch(int offset) {
        switches &= (~(1L << offset));
    }

    /**
     * 开关是否打开
     *
     * @param offset switches
     * @return
     */
    public boolean isSwitchOpen(int offset) {
        return (switches & (1L << offset)) != 0;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getActivityId() {
        return activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public Long getIndustry() {
        return industry;
    }

    public void setIndustry(Long industry) {
        this.industry = industry;
    }

    public Long getIndustryType() {
        return industryType;
    }

    public void setIndustryType(Long industryType) {
        this.industryType = industryType;
    }

    public Long getCustomer() {
        return customer;
    }

    public void setCustomer(Long customer) {
        this.customer = customer;
    }

    public String getIndicators() {
        return indicators;
    }

    public void setIndicators(String indicators) {
        this.indicators = indicators;
    }

    public Long getPlaywayType() {
        return playwayType;
    }

    public void setPlaywayType(Long playwayType) {
        this.playwayType = playwayType;
    }

    public String getPlaywayName() {
        return playwayName;
    }

    public void setPlaywayName(String playwayName) {
        this.playwayName = playwayName;
    }

    public String getPlaywayModules() {
        return playwayModules;
    }

    public void setPlaywayModules(String playwayModules) {
        this.playwayModules = playwayModules;
    }

    public String getPlaywayText() {
        return playwayText;
    }

    public void setPlaywayText(String playwayText) {
        this.playwayText = playwayText;
    }

    public String getVisualUrl() {
        return visualUrl;
    }

    public void setVisualUrl(String visualUrl) {
        this.visualUrl = visualUrl;
    }

    public String getDemandUrl() {
        return demandUrl;
    }

    public void setDemandUrl(String demandUrl) {
        this.demandUrl = demandUrl;
    }

    public Long getChannel() {
        return channel;
    }

    public void setChannel(Long channel) {
        this.channel = channel;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getEntryText() {
        return entryText;
    }

    public void setEntryText(String entryText) {
        this.entryText = entryText;
    }

    public String getUserTypes() {
        return userTypes;
    }

    public void setUserTypes(String userTypes) {
        this.userTypes = userTypes;
    }

    public String getUserScenario() {
        return userScenario;
    }

    public void setUserScenario(String userScenario) {
        this.userScenario = userScenario;
    }

    public String getMarketingMode() {
        return marketingMode;
    }

    public void setMarketingMode(String marketingMode) {
        this.marketingMode = marketingMode;
    }

    public String getReachMode() {
        return reachMode;
    }

    public void setReachMode(String reachMode) {
        this.reachMode = reachMode;
    }

    public String getCustomerBudget() {
        return customerBudget;
    }

    public void setCustomerBudget(String customerBudget) {
        this.customerBudget = customerBudget;
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getExpectGoals() {
        return expectGoals;
    }

    public void setExpectGoals(String expectGoals) {
        this.expectGoals = expectGoals;
    }

    public String getSatisfactionGrade() {
        return satisfactionGrade;
    }

    public void setSatisfactionGrade(String satisfactionGrade) {
        this.satisfactionGrade = satisfactionGrade;
    }

    public String getSatisfactionUrl() {
        return satisfactionUrl;
    }

    public void setSatisfactionUrl(String satisfactionUrl) {
        this.satisfactionUrl = satisfactionUrl;
    }

    public Integer getValidation() {
        return validation;
    }

    public void setValidation(Integer validation) {
        this.validation = validation;
    }

    public String getValidationText() {
        return validationText;
    }

    public void setValidationText(String validationText) {
        this.validationText = validationText;
    }

    public String getExpectData() {
        return expectData;
    }

    public void setExpectData(String expectData) {
        this.expectData = expectData;
    }

    public String getPptUrl() {
        return pptUrl;
    }

    public void setPptUrl(String pptUrl) {
        this.pptUrl = pptUrl;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getSwitches() {
        return switches;
    }

    public void setSwitches(Long switches) {
        this.switches = switches;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public String getCreater() {
        return creater;
    }

    public void setCreater(String creater) {
        this.creater = creater;
    }

    public String getModifiedUser() {
        return modifiedUser;
    }

    public void setModifiedUser(String modifiedUser) {
        this.modifiedUser = modifiedUser;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getVisualImages() {
        return visualImages;
    }

    public void setVisualImages(String visualImages) {
        this.visualImages = visualImages;
    }

    public String getEntryImages() {
        return entryImages;
    }

    public void setEntryImages(String entryImages) {
        this.entryImages = entryImages;
    }

    public String getSatisfactions() {
        return satisfactions;
    }

    public void setSatisfactions(String satisfactions) {
        this.satisfactions = satisfactions;
    }

    /**
     * 客户预期目标
     */
    public static class ExpectGoal implements Serializable {

        private static final long serialVersionUID = 3285750301039958844L;

        private Long type;
        private String text;

        public Long getType() {
            return type;
        }

        public void setType(Long type) {
            this.type = type;
        }

        public String getText() {
            return text;
        }

        public void setText(String text) {
            this.text = text;
        }
    }

    /**
     * 客户满意度
     */
    public static class Satisfaction implements Serializable {

        private static final long serialVersionUID = -2285775061657659519L;

        private String grade;
        private String url;

        public String getGrade() {
            return grade;
        }

        public void setGrade(String grade) {
            this.grade = grade;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}