package cn.com.duiba.developer.center.api.domain.dto.strategy;

import cn.com.duiba.developer.center.api.domain.bean.CascadeData;
import cn.com.duiba.developer.center.api.domain.enums.StrategyDynamicDataTypeEnum;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 动态类型数据，支持级联筛选
 *
 * @Author: xuwei
 * @Date: 2020/05/27
 */
public class StrategyDynamicDataDto implements Serializable {

    private static final long serialVersionUID = 6412928122210221593L;

    /**
     * 默认上级
     */
    public static final Long PARENT_DEFAULT = 0L;

    /**
     * 构建级联数据
     *
     * @param list
     * @return
     */
    public static Map<Long, CascadeData<Long, StrategyDynamicDataDto>> buildCascadeMap(List<StrategyDynamicDataDto> list) {

        //第一级数据
        Map<Long, CascadeData<Long, StrategyDynamicDataDto>> map = new HashMap<>();

        //第二级之后的数据按层级分组
        Map<Integer, List<StrategyDynamicDataDto>> levelGroup = new HashMap<>(8);

        //数据分层
        for (StrategyDynamicDataDto dynamicData : list) {
            //层级
            int level = 0;
            //确定层级，每一级占2位数字
            for (int parentType = dynamicData.getType() / 100; parentType != 0; parentType /= 100) {
                ++level;
            }
            if (level == 0) {
                map.put(dynamicData.getId(), new CascadeData<>(dynamicData.getId(), dynamicData));
            } else {
                levelGroup.computeIfAbsent(level, k -> new ArrayList<>()).add(dynamicData);
            }
        }

        //构建二级及其之后的级联数据
        for (int i = 1; ; ++i) {
            List<StrategyDynamicDataDto> group = levelGroup.get(i);
            //层级肯定是连续的，如果某一层级无数据，说明已经到底层了
            if (group == null) {
                break;
            }
            for (StrategyDynamicDataDto dynamicData : group) {
                //父级数据
                CascadeData<Long, StrategyDynamicDataDto> parentData = map.get(dynamicData.getParentId());
                if (parentData != null) {
                    parentData.addChild(dynamicData.getId(), dynamicData);
                }
            }
        }
        return map;
    }


    /**
     * ID
     */
    private Long id;

    /**
     * 上级ID
     */
    private Long parentId;

    /**
     * 数据类型 10:行业 1000:客户 1001:经营指标 11:玩法类型 12:玩法组件 13:投放渠道 14:面向用户 15:预期目标 16:经验类型 17:经验标签 18:数据模板 19:数据模板字段
     * @see {@link StrategyDynamicDataTypeEnum}
     */
    private Integer type;

    /**
     * 名称
     */
    private String name;

    /**
     * 数据
     */
    private String data;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}