package cn.com.duiba.developer.center.api.domain.dto.strategy;

import cn.com.duiba.developer.center.api.domain.constant.StrategyExperienceStatusEnum;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 经验
 *
 * @Author: xuwei
 * @Date: 2020/05/27
 */
public class StrategyExperienceDto implements Serializable {

    private static final long serialVersionUID = 8244496459233711665L;

    /**
     * ID
     */
    private Long id;

    /**
     * 类型
     * 从级联表中取
     */
    @NotNull
    private Integer type;

    /**
     * 经验来源ID
     */
    private Long sourceId;

    /**
     * 标签
     */
    private String tags;
    private List<String> tagsDesc;

    /**
     * 经验描述
     */
    @NotBlank
    @Length(max = 1000)
    private String description;

    /**
     * 有效用户&场景
     */
    @Length(max = 1000)
    private String validationTarget;

    /**
     * 有效性论证
     */
    @Length(max = 1000)
    private String validationProof;

    /**
     * 创建者姓名
     */
    private String creater;

    /**
     * 状态 0:待审核 1:审核通过 2:审核拒绝
     * {@link StrategyExperienceStatusEnum}
     */
    private Integer status;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 被应用在案例中的次数
     */
    private Long relatedCaseCount;
    /**
     * 被应用在有效案例中的次数
     */
    private Long relatedValidCaseCount;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getTags() {
        return tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getValidationTarget() {
        return validationTarget;
    }

    public void setValidationTarget(String validationTarget) {
        this.validationTarget = validationTarget;
    }

    public String getValidationProof() {
        return validationProof;
    }

    public void setValidationProof(String validationProof) {
        this.validationProof = validationProof;
    }

    public String getCreater() {
        return creater;
    }

    public void setCreater(String creater) {
        this.creater = creater;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getRelatedCaseCount() {
        return relatedCaseCount;
    }

    public void setRelatedCaseCount(Long relatedCaseCount) {
        this.relatedCaseCount = relatedCaseCount;
    }

    public Long getRelatedValidCaseCount() {
        return relatedValidCaseCount;
    }

    public void setRelatedValidCaseCount(Long relatedValidCaseCount) {
        this.relatedValidCaseCount = relatedValidCaseCount;
    }

    public List<String> getTagsDesc() {
        return tagsDesc;
    }

    public void setTagsDesc(List<String> tagsDesc) {
        this.tagsDesc = tagsDesc;
    }
}