package cn.com.duiba.developer.center.api.domain.enums;

/**
 * 策略后台动态数据类型枚举 <br>
 *
 * @author: xuwei
 * @date: 2020/5/27
 */
public enum StrategyDynamicDataTypeEnum {
    INDUSTRY(10, "行业"),
    INDUSTRY_TYPE(1000, "行业分类"),
    CUSTOMER(1001, "客户"),
    INDICATOR(1002, "经营指标"),
    PLAYWAY_TYPE(11, "玩法类型"),
    PLAYWAY_MODULE(12, "组件"),
    CHANNEL(13, "投放渠道"),
    USER_TYPE(14, "面向用户"),
    EXPECT_GOAL(15, "预期目标"),
    EXPERIENCE_TYPE(16, "经验类型"),
    EXPERIENCE_TAG(17, "经验标签"),
    TEMPLATE(18, "数据模板"),
    TEMPLATE_FIELD(19, "数据模板字段"),
    ;

    Integer type;
    String name;

    StrategyDynamicDataTypeEnum(int type, String name) {
        this.type = type;
        this.name = name;
    }

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }
}
