package cn.com.duiba.developer.center.api.remoteservice.strategy;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.strategy.StrategyExperienceDetailDto;
import cn.com.duiba.developer.center.api.domain.dto.strategy.StrategyExperienceDto;
import cn.com.duiba.developer.center.api.domain.paramquery.strategy.ExperienceQueryParam;

import java.util.List;

/**
 * 经验-远程服务接口
 *
 * @Author: xuwei
 * @Date: 2020/05/27
 */
@AdvancedFeignClient
public interface RemoteStrategyExperienceService {
    /**
     * 新建经验
     *
     * @param experienceDto
     * @return
     */
    Long save(StrategyExperienceDto experienceDto);

    /**
     * 查询经验
     *
     * @param param
     * @return
     */
    List<StrategyExperienceDto> query(ExperienceQueryParam param);

    /**
     * 待审核的经验数量
     *
     * @param param
     * @return
     */
    Long waitAuditCount(ExperienceQueryParam param);

    StrategyExperienceDetailDto detail(Long id);

    /**
     * 审核经验
     *
     * @param id
     * @param status
     * @return
     */
    Boolean audit(Long id, Integer status);

    /**
     * 删除经验
     *
     * @param id     经验Id
     * @param userId 操作人
     * @return
     */
    Boolean delete(Long id, Long userId);
}