package cn.com.duiba.developer.center.api.domain.enums.forum;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zyj on 2018/5/18.
 */
public enum AnnouncementExpandEnum {
    /**
     * 公告上下篇类型
     */
    EXPAND_PREV(1,"上一篇"),
    EXPAND_NEXT(2,"下一篇");

    private static final Map<Integer, AnnouncementExpandEnum> ENUM_MAP = new HashMap<>();
    static{
        for(AnnouncementExpandEnum expandEnum : values()){
            ENUM_MAP.put(expandEnum.getValue(), expandEnum);
        }
    }

    public static AnnouncementExpandEnum getByCode(Integer code){
        AnnouncementExpandEnum expandEnum = ENUM_MAP.get(code);
        if(expandEnum == null){
            throw new DeveloperCenterException("不支持的类型");
        }
        return expandEnum;
    }

    private int   value;
    private String desc;

    AnnouncementExpandEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
