package cn.com.duiba.developer.center.api.domain.paramquery;

import cn.com.duiba.developer.center.api.domain.enums.saas.AgentPaymentMethodEnum;
import cn.com.duiba.developer.center.api.domain.enums.saas.AuditStatusEnum;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: chengsiyi
 */
public class SaasChargeApplyParams extends PageQueryParam implements Serializable{

    private static final long serialVersionUID = -7834620837090178114L;

    /**
     * 充值单号
     */
    private Long id;

    /**
     * 代理商ID
     */
    private List<Long> agentIds;

    /**
     * 充值状态
     */
    private AuditStatusEnum state;

    /**
     * 充值类型
     */
    private AgentPaymentMethodEnum payment;

    /**
     * 充值日期-开始
     */
    private Date gmtCreateStart;

    /**
     * 充值日期-结束
     */
    private Date gmtCreateEnd;

    /**
     * 审核日期-开始
     */
    private Date gmtProcessStart;

    /**
     * 审核日期-结束
     */
    private Date gmtProcessEnd;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<Long> getAgentIds() {
        return agentIds;
    }

    public void setAgentIds(List<Long> agentIds) {
        this.agentIds = agentIds;
    }

    public AuditStatusEnum getState() {
        return state;
    }

    public void setState(AuditStatusEnum state) {
        this.state = state;
    }

    public AgentPaymentMethodEnum getPayment() {
        return payment;
    }

    public void setPayment(AgentPaymentMethodEnum payment) {
        this.payment = payment;
    }

    public Date getGmtCreateStart() {
        return gmtCreateStart;
    }

    public void setGmtCreateStart(Date gmtCreateStart) {
        this.gmtCreateStart = gmtCreateStart;
    }

    public Date getGmtCreateEnd() {
        return gmtCreateEnd;
    }

    public void setGmtCreateEnd(Date gmtCreateEnd) {
        this.gmtCreateEnd = gmtCreateEnd;
    }

    public Date getGmtProcessStart() {
        return gmtProcessStart;
    }

    public void setGmtProcessStart(Date gmtProcessStart) {
        this.gmtProcessStart = gmtProcessStart;
    }

    public Date getGmtProcessEnd() {
        return gmtProcessEnd;
    }

    public void setGmtProcessEnd(Date gmtProcessEnd) {
        this.gmtProcessEnd = gmtProcessEnd;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
