package cn.com.duiba.developer.center.api.domain.bean;

import java.util.HashMap;
import java.util.Map;

/**
 * 级联数据
 */
public class CascadeData<K, D> {
    private K key;
    private D data;

    private Map<K, CascadeData<K, D>> children = new HashMap<>();

    public CascadeData(K key, D data) {
        this.key = key;
        this.data = data;
    }

    public K getKey() {
        return key;
    }

    public D getData() {
        return data;
    }

    public CascadeData<K, D> addChild(K key, D data) {
        return children.put(key, new CascadeData<>(key, data));
    }

    public CascadeData<K, D> getChild(K key) {
        return children.get(key);
    }
}
