package cn.com.duiba.developer.center.api.domain.dto.crm;

import java.io.Serializable;
import java.util.Date;

/**
* 客户线索表
*/
public class ClueDto implements Serializable {

    private static final long serialVersionUID = 7646516491885920152L;
    /**
     *
     */
    private Long id;

    /**
     * 录入用户信息
     */
    private Long adminId;


    /**
     * 客户简称
     */
    private String shortName;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 公司所在省份
     */
    private String addressPrivince;

    /**
     * 公司所在城市
     */
    private String addressCity;

    /**
     * 公司所在详细地址
     */
    private String addressDetail;

    /**
     * 客户分组，1：全行业，2：银行，3：政企，4：淘宝，5：保险
     */
    private Integer groupType;

    /**
     * 客户分层，1：未定，2：中长尾，3：KA，4：GSKA
     */
    private Integer layerType;

    /**
     * 一级行业
     */
    private String headIndustry;

    /**
     * 二级行业
     */
    private String secondIndustry;

    /**
     * 合作目的 1. 未知 2 积分消耗 3 用户留存 4 会员活跃 5 用户拉新 6 采购 7 其他
     */
    private String purpose;

    /**
     * 合作状态 1. 未合作 2 合作中 3 合作终止
     */
    private Integer purposeStatus;

    /**
     * 合作方式 1 积分商城 2 定制活动
     */
    private String purposeType;

    /**
     * 合作供应商
     */
    private String purposeSupplier;

    /**
     * 访问时间
     */
    private Long createUser;



    /**
     * 预算
     */
    private Long budget;

    /**
     * 可挖掘点
     */
    private String excavatePoint;

    /**
     * 载体 1. 未知 2 App 3 公众号 4 小程序
     */
    private String carrierInfo;

    /**
     * 业务主体 1. 未定，2 兑吧 3 兑啊 4 兑捷
     */
    private Integer subjectInfo;

    /**
     * 线上入口 1 未知 2 一级 3 二级 4 三级
     */
    private Integer onlineEnter;

    /**
     * 开发者信息json
     */
    private String developerJson;

    /**
     * 访问时间
     */
    private Date visitTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getAdminId() {
        return adminId;
    }

    public void setAdminId(Long adminId) {
        this.adminId = adminId;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getShortName() {
        return shortName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getCompanyName() {
        return companyName;
    }


    public void setGroupType(Integer groupType) {
        this.groupType = groupType;
    }

    public Integer getGroupType() {
        return groupType;
    }

    public void setLayerType(Integer layerType) {
        this.layerType = layerType;
    }

    public Integer getLayerType() {
        return layerType;
    }

    public void setHeadIndustry(String headIndustry) {
        this.headIndustry = headIndustry;
    }

    public String getHeadIndustry() {
        return headIndustry;
    }

    public void setSecondIndustry(String secondIndustry) {
        this.secondIndustry = secondIndustry;
    }

    public String getSecondIndustry() {
        return secondIndustry;
    }


    public String getAddressPrivince() {
        return addressPrivince;
    }

    public void setAddressPrivince(String addressPrivince) {
        this.addressPrivince = addressPrivince;
    }

    public String getAddressCity() {
        return addressCity;
    }

    public void setAddressCity(String addressCity) {
        this.addressCity = addressCity;
    }

    public String getAddressDetail() {
        return addressDetail;
    }

    public void setAddressDetail(String addressDetail) {
        this.addressDetail = addressDetail;
    }

    public String getPurpose() {
        return purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public Integer getPurposeStatus() {
        return purposeStatus;
    }

    public void setPurposeStatus(Integer purposeStatus) {
        this.purposeStatus = purposeStatus;
    }

    public String getPurposeType() {
        return purposeType;
    }

    public void setPurposeType(String purposeType) {
        this.purposeType = purposeType;
    }

    public String getCarrierInfo() {
        return carrierInfo;
    }

    public void setCarrierInfo(String carrierInfo) {
        this.carrierInfo = carrierInfo;
    }

    public void setBudget(Long budget) {
        this.budget = budget;
    }

    public Long getBudget() {
        return budget;
    }

    public void setExcavatePoint(String excavatePoint) {
        this.excavatePoint = excavatePoint;
    }

    public String getExcavatePoint() {
        return excavatePoint;
    }

    public void setSubjectInfo(Integer subjectInfo) {
        this.subjectInfo = subjectInfo;
    }

    public Integer getSubjectInfo() {
        return subjectInfo;
    }

    public void setOnlineEnter(Integer onlineEnter) {
        this.onlineEnter = onlineEnter;
    }

    public Integer getOnlineEnter() {
        return onlineEnter;
    }

    public void setDeveloperJson(String developerJson) {
        this.developerJson = developerJson;
    }

    public String getDeveloperJson() {
        return developerJson;
    }

    public void setVisitTime(Date visitTime) {
        this.visitTime = visitTime;
    }

    public Date getVisitTime() {
        return visitTime;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public String getPurposeSupplier() {
        return purposeSupplier;
    }

    public void setPurposeSupplier(String purposeSupplier) {
        this.purposeSupplier = purposeSupplier;
    }
}

