package cn.com.duiba.developer.center.api.domain.dto.crm;

import java.io.Serializable;
import java.util.Date;

/**
* 客户线索表
*/
public class ClueDto implements Serializable {

    private static final long serialVersionUID = 7646516491885920152L;
    /**
    * 
    */
    private Long id;

    /**
    * 客户简称
    */
    private String shortName;

    /**
    * 公司名称
    */
    private String companyName;

    /**
    * 公司所在省份
    */
    private String address;

    /**
    * 客户分组，1：全行业，2：银行，3：政企，4：淘宝，5：保险
    */
    private Integer groupType;

    /**
    * 客户分层，1：未定，2：中长尾，3：KA，4：GSKA
    */
    private Integer layerType;

    /**
    * 一级行业
    */
    private String headIndustry;

    /**
    * 二级行业
    */
    private String secondIndustry;

    /**
    * 合作目的 1. 未知 2 积分消耗 3 用户留存 4 会员活跃 5 用户拉新 6 采购 7 其他
    */
    private Integer purpose;

    /**
    * 合作状态 1. 未合作 2 合作中 3 合作终止
    */
    private Integer purposeStatus;

    /**
    * 合作方式 1 积分商城 2 定制活动
    */
    private Integer purposeType;

    /**
     * 合作供应商
     */
    private String purposeSupplier;

    /**
    * 预算
    */
    private Long budget;

    /**
    * 可挖掘点
    */
    private String excavatePoint;

    /**
    * 载体 1. 未知 2 App 3 公众号 4 小程序
    */
    private Integer carrierInfo;

    /**
    * 业务主体 1. 未定，2 兑吧 3 兑啊 4 兑捷 
    */
    private Integer subjectInfo;

    /**
    * 线上入口 1 未知 2 一级 3 二级 4 三级
    */
    private Integer onlineEnter;

    /**
    * 开发者信息json
    */
    private String developerJson;

    /**
    * 访问时间
    */
    private Date visitTime;

    /**
     * 访问时间
     */
    private Long createUser;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getShortName() {
        return shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Integer getGroupType() {
        return groupType;
    }

    public void setGroupType(Integer groupType) {
        this.groupType = groupType;
    }

    public Integer getLayerType() {
        return layerType;
    }

    public void setLayerType(Integer layerType) {
        this.layerType = layerType;
    }

    public String getHeadIndustry() {
        return headIndustry;
    }

    public void setHeadIndustry(String headIndustry) {
        this.headIndustry = headIndustry;
    }

    public String getSecondIndustry() {
        return secondIndustry;
    }

    public void setSecondIndustry(String secondIndustry) {
        this.secondIndustry = secondIndustry;
    }

    public Integer getPurpose() {
        return purpose;
    }

    public void setPurpose(Integer purpose) {
        this.purpose = purpose;
    }

    public Integer getPurposeStatus() {
        return purposeStatus;
    }

    public void setPurposeStatus(Integer purposeStatus) {
        this.purposeStatus = purposeStatus;
    }

    public Integer getPurposeType() {
        return purposeType;
    }

    public void setPurposeType(Integer purposeType) {
        this.purposeType = purposeType;
    }

    public String getPurposeSupplier() {
        return purposeSupplier;
    }

    public void setPurposeSupplier(String purposeSupplier) {
        this.purposeSupplier = purposeSupplier;
    }

    public Long getBudget() {
        return budget;
    }

    public void setBudget(Long budget) {
        this.budget = budget;
    }

    public String getExcavatePoint() {
        return excavatePoint;
    }

    public void setExcavatePoint(String excavatePoint) {
        this.excavatePoint = excavatePoint;
    }

    public Integer getCarrierInfo() {
        return carrierInfo;
    }

    public void setCarrierInfo(Integer carrierInfo) {
        this.carrierInfo = carrierInfo;
    }

    public Integer getSubjectInfo() {
        return subjectInfo;
    }

    public void setSubjectInfo(Integer subjectInfo) {
        this.subjectInfo = subjectInfo;
    }

    public Integer getOnlineEnter() {
        return onlineEnter;
    }

    public void setOnlineEnter(Integer onlineEnter) {
        this.onlineEnter = onlineEnter;
    }

    public String getDeveloperJson() {
        return developerJson;
    }

    public void setDeveloperJson(String developerJson) {
        this.developerJson = developerJson;
    }

    public Date getVisitTime() {
        return visitTime;
    }

    public void setVisitTime(Date visitTime) {
        this.visitTime = visitTime;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}

