package cn.com.duiba.developer.center.api.domain.enums.caseLibraryType;

import java.util.ArrayList;
import java.util.List;

public enum CaseSecondSortEnum {
    FINANCIAL_BANK(2001,"金融银行",1001),
    INTERNET(2002,"互联网",1001),
    NEW_RETAIL(2003,"新零售",1001),
    GOVERNMENT_ENTERPRISE_PEOPLE(2004,"政企民生",1001),
    TAOBAO_E_COMMERCE(2005,"淘宝电商",1001),
    OFFLINE_STORE(2006,"线下到店",1001),
    GAME_CULTIVATION(2007,"游戏化养成",1002),
    SIGN_IN(2008,"签到打卡",1002),
    MINI_GAME(2009,"小游戏",1002),
    COLLECT_CARD(2010,"集卡助力",1002),
    ANSWER_TEST(2011,"答题测试",1002),
    HOLIDAY_HOTSPOT(2012,"节假日热点",1002),
    FIGHTING_BARGAIN(2013,"拼团砍价",1002),
    E_COMMERCE_PROMOTION(2014,"电商促销",1002),
    CREATIVE_COMMUNICATION(2015,"创意传播",1002),
    LOTTERY(2016,"抽奖活动",1002),
    FISSION_REFRESH(2017,"裂变拉新",1003),
    PROMOTE_ACTIVE(2018,"促进活跃",1003),
    PROMOTE_RETAIN(2019,"提升留存",1003),
    DRAIN_TO_STORE(2020,"引流到店",1003),
    PROMOTIONAL_TRANSACTION(2021,"提升交易",1003),
    INTEGRAL_CONSUMPTION(2022,"积分消耗",1003),
    FESTIVAL_HOTSPOT(2023, "节日热点", 1002),

    ;
    private String value;
    private Integer key;
    private Integer preValue;
    CaseSecondSortEnum(Integer key,String value,Integer preValue)
    {
        this.value=value;
        this.key=key;
        this.preValue=preValue;
    }

    public Integer getPreValue() {
        return preValue;
    }

    public String getValue() {
        return value;
    }

    public Integer getKey() {
        return key;
    }
    public static CaseSecondSortEnum typeEnumCheck(int key)
    {

        CaseSecondSortEnum[] values=CaseSecondSortEnum.values();
        for(CaseSecondSortEnum caseSecondSortEnum:values)
        {
            if(caseSecondSortEnum.getKey().intValue()==key)
            {
                return caseSecondSortEnum;
            }
        }
        return null;

    }
    public static List<CaseSecondSortEnum> getSecondListByFirstKey(int key){
        List<CaseSecondSortEnum> caseSecondSortEnumList=new ArrayList<>();
        CaseSecondSortEnum[] values=CaseSecondSortEnum.values();
        for(CaseSecondSortEnum caseSecondSortEnum:values)
        {
            if(caseSecondSortEnum.getPreValue().intValue()==key)
            {
                caseSecondSortEnumList.add(caseSecondSortEnum);
            }
        }
        return caseSecondSortEnumList;
    }

}
