package cn.com.duiba.developer.center.api.domain.enums;

import java.util.Objects;

public enum AppExpSwitchEnum {
    ON("on","开启经验体系"),
    OFF("off","关闭经验体系");

    private String status;

    private String desc;

    AppExpSwitchEnum(String status,String desc){
        this.status = status;
        this.desc = desc;
    }

    public String getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    public static AppExpSwitchEnum getEnumByStatus(String status){
        if(null==status){
            return null;
        }
        for (AppExpSwitchEnum enumVal : AppExpSwitchEnum.values()) {
            if (Objects.equals(status,enumVal.getStatus())) {
                return enumVal;
            }
        }
        return null;
    }
}
