package cn.com.duiba.developer.center.api.domain.enums;

/**
 * @program: developer-center
 * @description: app秒杀展示类型枚举
 * @author: Simba
 * @create: 2019-08-05 16:57
 **/
public enum AppSeckillShowTypeEnum {

    NOT_SHOW(0, "不展示"),
    PURCHASED_NUM(1, "已购数量"),
    REMAIN_NUM(2, "剩余数量"),
    ;

    private int type;
    private String desc;

    AppSeckillShowTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }


    public static AppSeckillShowTypeEnum getEnumByType(Integer type) {
        if (null == type) {
            return null;
        }
        for (AppSeckillShowTypeEnum showTypeEnum : AppSeckillShowTypeEnum.values()) {
            if (type == showTypeEnum.getType()) {
                return showTypeEnum;
            }
        }
        return null;
    }
}

